function varargout = Segmentation(varargin)
% SEGMENTATION MATLAB code for Segmentation.fig
%      SEGMENTATION, by itself, creates a new SEGMENTATION or raises the existing
%      singleton*.
%
%      H = SEGMENTATION returns the handle to a new SEGMENTATION or the handle to
%      the existing singleton*.
%
%      SEGMENTATION('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SEGMENTATION.M with the given input arguments.
%
%      SEGMENTATION('Property','Value',...) creates a new SEGMENTATION or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Segmentation_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Segmentation_OpeningFcn via v
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Segmentation

% Last Modified by GUIDE v2.5 03-May-2013 16:00:24

% Begin initialization code - DO NOT EDIT

gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @Segmentation_OpeningFcn, ...
    'gui_OutputFcn',  @Segmentation_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Segmentation is made visible.
function Segmentation_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Segmentation (see VARARGIN)

% Choose default command line output for Segmentation
handles.output = hObject;
handles.trainfilesinfo = [];
handles.imgIdx =0;
handles.FLAG = true;
% handles.samples = cell(1,1);
handles.samples={};

functionname='Segmentation.m';
functiondir=which(functionname);
functiondir=functiondir(1:end-length(functionname));
addpath([functiondir '/HelpFuncs'])

handles.ImgNum=0;

set(handles.text1,'String','Please choose train images to start.');

%Test Figure Settings

handles.testImgNum=0;

handles.testtrainfile=[];

set(handles.text4,'String','Please choose trained .mat file and test images to start.');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Segmentation wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Segmentation_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in nextImageButton.
function nextImageButton_Callback(hObject, eventdata, handles)
% hObject    handle to nextImageButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if  handles.ImgNum==0
    msgbox('You have not chosen any train images yet!','Warning')
else
    handles.imgIdx=handles.imgIdx+1;
    set(handles.currentButton,'Enable','On');
    if  handles.imgIdx>1
        set(handles.prevImageButton,'Enable','On');
    end
    set(handles.text1,'String',['Current Image ', num2str(handles.imgIdx), '/', num2str(handles.ImgNum)]);
    set(handles.nextImageButton,'String','Next');
    
    if  handles.imgIdx>=handles.ImgNum
        set(handles.nextImageButton,'Enable','Off');
        %         msgbox('You have reached the first image!','Warning')
    end
    guidata(hObject, handles);
    update_display(hObject, eventdata, handles);
end

%
% --- Executes on button press in prevImageButton.
function prevImageButton_Callback(hObject, eventdata, handles)
% hObject    handle to prevImageButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if handles.ImgNum==0
    msgbox('You have not chosen any train images yet!','Warning')
    
else   
    handles.imgIdx=handles.imgIdx-1;
    if  handles.imgIdx<handles.ImgNum
        set(handles.nextImageButton,'Enable','On');
    end
    set(handles.text1,'String',['Current Image ', num2str(handles.imgIdx), '/', num2str(handles.ImgNum)]);
      
    if  handles.imgIdx<=1
        %             msgbox('You have reached the first image!','Warning');
        set(handles.prevImageButton,'Enable','Off');
    end
    
    guidata(hObject, handles);
    update_display(hObject, eventdata, handles);
end

% --- Executes on button press in currentButton.
function currentButton_Callback(hObject, eventdata, handles)
% hObject    handle to currentButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.text1,'String',['Current Image ', num2str(handles.imgIdx), '/', num2str(handles.ImgNum)]);
guidata(hObject, handles);
update_display(hObject, eventdata, handles);



% --- Executes on button press in startTrainButton.
function startTrainButton_Callback(hObject, eventdata, handles)
% hObject    handle to startTrainButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if  isempty(handles.samples)
    msgbox('You have not cropped any patches yet!','Warning')
    return;
elseif  (handles.FLAG)
    msgbox('You have not cropped any patches yet!','Warning')
    return;
end
[~, name, ~] = fileparts(handles.filename{1});
[file,path] = uiputfile('*.mat','Save Workspace As',['.\Train Result\' name '.mat']);
if file==0
    msgbox('You did not pick up any file name, please give one!','Warning') ;
    return;
end
msgbox('Generally, the training stage takes a while. Please be patient. Press OK to start!','Start Training');
set(handles.text1,'String','Please be patient. It is training the templates...');

[ImgPatch_Cluster] = CombineTpCluster(handles.samples);

fprintf('Totally %d nuclei samples are selected.\n',length(ImgPatch_Cluster));

fprintf('Start to train the nuclei samples selected...\n');

%%% deal with the case of rgb version
% RGBFlag=0;
% 
% for i=1:size(ImgPatch_Cluster,2)
%     [M,N,K] = size(ImgPatch_Cluster{1,i});
%     if K==3
%         RGBFlag=1;
%     end
% end

% [simulated_tp_cluster_all,MeanTp,MeanTpMsk] = PCA_Template_Generator(ImgPatch_Cluster,RGBFlag);

[simulated_tp_cluster_all,MeanTp,MeanTpMsk] = PCA_Template_Generator_New(ImgPatch_Cluster);

save([path file],'simulated_tp_cluster_all');
set(handles.text1,'String','You have finished the training.');
pause (1);
msgbox(['The trained result is stored:' path file],'Training Stage Completed');
set(handles.text1,'String','Please choose train images to start.');




% --------------------------------------------------------------------
function trainingTab_Callback(hObject, eventdata, handles)
% hObject    handle to trainingTab (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function openTrainImage_Callback(hObject, eventdata, handles)
% hObject    handle to openTrainImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname,~]=uploadimage(hObject, eventdata, handles);
files={};

if isnumeric(filename)
    return;
else
    if iscell(filename)
        ImgNum=length(filename);
        for i=1:ImgNum
            files{i}=[pathname filename{i}];
        end        
    else
        ImgNum=1;
        files{1}=[pathname filename];
    end
end

handles.imgIdx=0;
handles.ImgNum=ImgNum;
handles.filename=files;
handles.samples=cell(ImgNum,1);
handles.Seeds=cell(ImgNum,1);

set(handles.nextImageButton,'Enable','Off');
set(handles.currentButton,'Enable','off');
set(handles.prevImageButton,'Enable','off');
set(handles.nextImageButton,'String','First');
set(handles.nextImageButton,'Enable','on');
set(handles.text1,'String',['Processing Image ', num2str(handles.imgIdx), '/', num2str(handles.ImgNum)]);

guidata(hObject, handles);



function update_display(hObject, eventdata, handles)
ImgNum=handles.ImgNum;
% handles.FLAG


RawImg = imread(handles.filename{handles.imgIdx});

%%% note that we convert rgb images to grayscale images
%%% and normalize the intensity range to [0,1]
RawImgSz = size(RawImg);
if length(RawImgSz)==3
    %%% in order to process color images
    OrigImg = mat2gray(double(RawImg));
%     OrigImg = double(rgb2gray(uint8(RawImg)));
%     OrigImg = mat2gray(OrigImg);
else
    OrigImg = mat2gray(double(RawImg));
end


switch get(get(handles.ContourSelectionPanel,'SelectedObject'),'Tag')
    case 'rectButton'
        [ImgPatch_Cluster,ShowMask,Seeds] =  manualselectpatches(OrigImg,handles,ImgNum);
    case 'lineButton'
        [ImgPatch_Cluster,ShowMask,Seeds] =  manualselectpatchesLine(OrigImg,handles,ImgNum);
        
end
guidata(hObject,handles);
if size(ImgPatch_Cluster{1,1},1)~=0
    handles.FLAG = false;
    if  isempty(handles.samples{handles.imgIdx,1})
        handles.samples{handles.imgIdx,1} = ImgPatch_Cluster;
        handles.Seeds{handles.imgIdx,1} = Seeds;
        
    else
        handles.samples{handles.imgIdx,1} = [handles.samples{handles.imgIdx,1} ImgPatch_Cluster];
        handles.Seeds{handles.imgIdx,1} = [handles.Seeds{handles.imgIdx,1} Seeds];
    end
end

guidata(hObject,handles);



function [filename, pathname,FilterIndex] =uploadimage(hObject, eventdata, handles)
[filename, pathname,FilterIndex] = uigetfile( ...
    {'*.png;*.jpg;*.jpeg;*.jpe;*.jfif;*.tif;*.tiff;*.bmp;*.dib;*.gif','Input Images(*.png,*.jpg,*.jpeg,*.tif,*.bmp,*.gif)';
    '*.png',  'PNG (*.png)'; ...
    '*.jpg;*.jpeg;*.jpe;*.jfif','JPEG (*.jpg,*.jpeg,*.jpe,*.jfif)'; ...
    '*.tif;*.tiff','TIFF (*.tif,*.tiff)'; ...
    '*.bmp;*.dib','Bitmap Files (*.bmp,*.dib)'; ...
    '*.gif','GIF(*.gif)'; ...
    '*.*',  'All Files (*.*)'}, ...
    'MultiSelect', 'on', ...
    'Choose Training Images');
guidata(hObject, handles);

% --------------------------------------------------------------------
function openTrainFolder_Callback(hObject, eventdata, handles)
% hObject    handle to openTrainFolder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
folder = uigetdir('./train images/','Choose the train image folder');

if isnumeric(folder)
    return;
else    
    files = dir(folder);
    N = size(files,1);
    ImgNum=0;
    fileName={};
    
    for i = 1:N
        if ~files(i).isdir
            ImgNum=ImgNum+1;
            fileName{ImgNum} = fullfile(folder,files(i).name);
            
        end
    end
end
handles.imgIdx=0;
handles.ImgNum =ImgNum;
handles.filename=fileName;

handles.samples=cell(ImgNum,1);
handles.Seeds=cell(ImgNum,1);


set(handles.nextImageButton,'Enable','Off');
set(handles.currentButton,'Enable','off');
set(handles.prevImageButton,'Enable','off');
set(handles.nextImageButton,'String','First');
set(handles.nextImageButton,'Enable','on');
set(handles.text1,'String',['Processing Image ', num2str(handles.imgIdx), '/', num2str(handles.ImgNum)]);


guidata(hObject, handles);



% set(handles.text1,'String',['Processing Image ', num2str(handles.imgIdx), '/', num2str(handles.ImgNum)]);

% update_display(hObject, eventdata, handles);
guidata(hObject, handles);


% --- Executes on button press in startTestButton.
function startTestButton_Callback(hObject, eventdata, handles)
% hObject    handle to startTestButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isempty(handles.testtrainfile)
    msgbox('You have not chosen any trained result .mat file yet. Please choose one then start to test.','Choose the Trained Result');
    return;
end

ImgNum =handles.testImgNum;
if ImgNum==0
    msgbox('You have not chosen any test images yet. Please choose the test image(s) then start to test.','Choose the Test Image');
    return;
end


res_dir = uigetdir('./Test Results/','Choose a folder to store the test results');
if res_dir==0
    msgbox('You did not pick up any directory, please choose one!','Warning') ;
    return;
end

res_dir= [res_dir '\' datestr(now,'dd-mmm-yyyy-THHMMSS') ];
mkdir(res_dir);



load(handles.testtrainfile);


patch_cluster_cell = cell(ImgNum,1);

% str=sprintf('%.2f', 90/(4*ImgNum));
% counts=0;
% gap=str2double(str);
% h = waitbar(0,'Testing Images....','Name','Test Processing');

for i_img = 1:ImgNum
    set(handles.text4,'String',['Processing Image ', num2str(i_img), '/', num2str(handles.testImgNum)]);
    
    fprintf('start to process %dth test image.\n',i_img);
    %     counts=counts+1;
    %     perc=gap*counts;
    %     waitbar(perc/100,h,sprintf('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));
    %
    FileName = handles.testfilename{i_img};
    TestImg = imread(FileName);
    
    TestImgSz = size(TestImg);
    
    %%% in this version, we normalize the image intensity within [0,1]
    if length(TestImgSz)==3
        TestImg = mat2gray(double(TestImg));
    else
        TestImg = mat2gray(double(TestImg));
    end
            
    [SeedPtMapRaw,RespMap,IdxMap] = Seed_Points_Detection_New(TestImg,simulated_tp_cluster_all);
    
    %% ratio value can be adjusted for better performance
    ratio = 0.60; %%% ratio exists within [0,1]
    th = max(RespMap(:))*ratio;
    SeedPtMap = SeedPtMapRaw.*double(RespMap>=th);
    
    %% show the results of detection by nxcorr2
    %%% you can comment this part if threshold is selected
    %%% or change the value of raio to see the detection result
    [SeedPtRow,SeedPtCol] = find(SeedPtMap);
    
    %% show the centers of cell/nucleus detected
    figure;
    imshow(TestImg,[],'Border','tight');
    hold on;
    for i_pt = 1:length(SeedPtRow)
        plot(SeedPtCol(i_pt),SeedPtRow(i_pt),'rx');
    end
    hold off;
    title('Result of Detection');
      
      %%% show the estimated shapes of each detected cell/nucleus
%     figure; imshow(TestImg,[],'Border','tight');
%     hold on;
%     for j_pt = 1:length(SeedPtRow)
%         imgSz = size(TestImg);
%         CurrentIdx = SeedPtMap(SeedPtRow(j_pt),SeedPtCol(j_pt));
%         CurrentTemplate = double(simulated_tp_cluster_all{2,CurrentIdx});
%         templateSz = size(CurrentTemplate);
%         offset1 = double(templateSz(1)-1)/2;
%         offset2 = double(templateSz(2)-1)/2;
%     
%         InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
%      
%         InitialMapExt(SeedPtRow(j_pt):SeedPtRow(j_pt)+2*offset1,...
%         SeedPtCol(j_pt):SeedPtCol(j_pt)+2*offset2) = ...
%             CurrentTemplate(1:templateSz(1),1:templateSz(2));
%         InitialMap(1:imgSz(1),1:imgSz(2)) = ...
%             InitialMapExt(1+offset1:imgSz(1)+offset1,1+offset2:imgSz(2)+offset2);
%         contour(InitialMap*2-1,[0 0],'b');    
%     end
%     hold off;

    
    %%
    
    %%% crop each nucleus into single image patch for processing
    %     counts=counts+2;
    %     perc=gap*counts;
    [SeedPtMapNew,Data_Cluster] = ...
        Detected_ImgPatch_Generator_New(TestImg,SeedPtMap,simulated_tp_cluster_all);
    
    %%% accurate segmentation using non-rigid registration
    %     counts=counts+1;
    %     perc=gap*counts;
    %     waitbar(perc/100,h,sprintf('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));
    fprintf('Start to refine the segmentation process.\n');
    
    [Final_BW_Result] = FinalAccurateSeg_New(Data_Cluster);
    
    %%% final results show and save
    [SaveImgOutput,Final_Seg_Obj] = Show_Final_Result2(TestImg,Final_BW_Result);
    
    %%% show the estimated shapes of each detected cell/nucleus
    figure; imshow(SaveImgOutput,[]);%title('Final Segmentation Result');f('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));

%     figure; imshow(SaveImgOutput,[]);title('Final Segmentation Result');f('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));
    
    
    %%% comment if you don't want to see the results
    %     figure; imshow(SaveImgOutput,[]);
    %     SaveFileName = sprintf(SaveFileFmt,i_img);
    [~, name, ~] = fileparts(FileName);
    
    SaveFileName = [res_dir '\' name '_output2.mat'];
    
    save(SaveFileName,'SaveImgOutput','Final_Seg_Obj','Data_Cluster','Final_BW_Result','SeedPtMapRaw','RespMap','IdxMap');
end
% perc=99;
% waitbar(perc/100,h,sprintf('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));
set(handles.text4,'String','Congratulations! You have finished the testing.');
pause(1);
% close (h);
msgbox(['Congratulations! The test results are stored at:' res_dir],'Testing Stage Completed');
set(handles.text4,'String','Please choose trained .mat file and test images to start.');


% --------------------------------------------------------------------
function openTestImage_Callback(hObject, eventdata, handles)
% hObject    handle to openTestImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname,~]=uploadimage(hObject, eventdata, handles);
files={};

if isnumeric(filename)
    return;
else
    if iscell(filename)
        ImgNum=length(filename);
        for i=1:ImgNum
            files{i}=[pathname filename{i}];
        end        
    else
        ImgNum=1;
        files{1}=[pathname filename];
    end   
end

handles.testImgNum =ImgNum;
handles.testfilename=files;
set(handles.text4,'String',['Processing Image ', '1/', num2str(handles.testImgNum)]);
guidata(hObject, handles);




% --------------------------------------------------------------------
function openTestFolder_Callback(hObject, eventdata, handles)
% hObject    handle to openTestFolder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
folder = uigetdir('./test images/','Choose the train image folder');

if isnumeric(folder)
    return;
else    
    files = dir(folder);
    N = size(files,1);
    ImgNum=0;
    fileName={};
    
    for i = 1:N
        if ~files(i).isdir
            ImgNum=ImgNum+1;
            fileName{ImgNum} = fullfile(folder,files(i).name);
            
        end
    end
end
handles.testImgNum =ImgNum;
handles.testfilename=fileName;
set(handles.text4,'String',['Processing Image ', '1/', num2str(handles.testImgNum)]);
guidata(hObject, handles);

% --------------------------------------------------------------------
function segmentationTab_Callback(hObject, eventdata, handles)
% hObject    handle to segmentationTab (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function [filename, pathname,FilterIndex] =uploadtrainfile(hObject, eventdata, handles)
% upload train file result

[filename, pathname,FilterIndex]  = uigetfile('*.mat','Select the trained result file','.\Train Result');

guidata(hObject, handles);


% --------------------------------------------------------------------
function loadTrainedFile_Callback(hObject, eventdata, handles)
% hObject    handle to loadTrainedFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname,~]=uploadtrainfile(hObject, eventdata, handles);
if isnumeric(filename)
    return;
else if iscell(filename)
        return;
        
    else
        handles.testtrainfile=[pathname filename];
    end    
end
guidata(hObject, handles);
