%%% this is the main program for the cell segmentation system: test stage
%%% using the cross-correlation idea
%%% version 1.10 (06-06-2012)
%%% written by Cheng Chen (chengchen@cmu.edu)

close all; 
clear;

%%% step 1: Seed Points Detection
%%% we calculate the cross-correlation to detect the seed points
%%% and the initial borders

directoryinfo = 'test images';
path(path,directoryinfo);

%%% indicate the image type, e.g. tif format
img_type = '*.png';
files = dir(fullfile(directoryinfo,img_type));

%%% set the mat file name to load the templates model
 load('meantemplate.mat');

%%% set the file name to store the results
% SaveFileFmt = 'final_result%d.mat';

%%% choose 4 slices for selecting nuclei candidates
ImgNum = size(files,1);
patch_cluster_cell = cell(ImgNum,1);

for i_img = 1:ImgNum
    fprintf('start to process %dth test image.\n',i_img);
    FileName = files(i_img,1).name;
    TestImg = imread(FileName);
   

    [SeedPtMapRaw,RespMap,IdxMap] = Seed_Points_Detection2(TestImg,simulated_tp_cluster_all);
    
    ratio = 0.70;
    th = max(RespMap(:))*ratio;
    SeedPtMap = SeedPtMapRaw.*double(RespMap>=th);
    
    
    
    %% show the results of detection by nxcorr2
    %%% you can comment this part if threshold is selected
    %%% or change the value of raio to see the detection result
    [SeedPtRow,SeedPtCol] = find(SeedPtMap);
    
    %%% show the centers of cell/nucleus detected
    figure; 
    imshow(TestImg,[],'Border','tight');
    hold on;
    for i_pt = 1:length(SeedPtRow)
        plot(SeedPtCol(i_pt),SeedPtRow(i_pt),'rx');
    end
    hold off;

    %%% show the estimated shapes of each detected cell/nucleus
    figure; imshow(TestImg,[],'Border','tight');
    hold on;
    for j_pt = 1:length(SeedPtRow)
        imgSz = size(TestImg);
        CurrentIdx = SeedPtMap(SeedPtRow(j_pt),SeedPtCol(j_pt));
        CurrentTemplate = double(simulated_tp_cluster_all{2,CurrentIdx});
        templateSz = size(CurrentTemplate);
        offset1 = double(templateSz(1)-1)/2;
        offset2 = double(templateSz(2)-1)/2;
    
        InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
     
        InitialMapExt(SeedPtRow(j_pt):SeedPtRow(j_pt)+2*offset1,...
        SeedPtCol(j_pt):SeedPtCol(j_pt)+2*offset2) = ...
            CurrentTemplate(1:templateSz(1),1:templateSz(2));
        InitialMap(1:imgSz(1),1:imgSz(2)) = ...
            InitialMapExt(1+offset1:imgSz(1)+offset1,1+offset2:imgSz(2)+offset2);
        contour(InitialMap*2-1,[0 0],'b');    
    end
    hold off;
    
    %%
    
    %%% crop each nucleus into single image patch for processing
    [SeedPtMapNew,Data_Cluster] = ...
        Detected_ImgPatch_Generator4(TestImg,SeedPtMap,simulated_tp_cluster_all);

    %%% accurate segmentation using non-rigid registration
    [Final_BW_Result] = FinalAccurateSeg(Data_Cluster);
    
    %%% final results show and save
    [SaveImgOutput,Final_Seg_Obj] = Show_Final_Result(TestImg,Final_BW_Result);

    %%% comment if you don't want to see the results
%     figure; imshow(SaveImgOutput,[]);
%     SaveFileName = sprintf(SaveFileFmt,i_img);
    
    SaveFileName = [FileName,'_output.mat'];
    
    save(SaveFileName,'SaveImgOutput','Final_Seg_Obj');
end






