function [Hx, Hy] = vectorSeperate(Hxy, Xpx, Ypx)

% Suppose that we compose the Hxy by [x0 y0 x1 y1 ... xn yn]

[dim, num] = size(Hxy);

for i = 1:num
    Hxv(:, i) = Hxy(1:2:(dim-1), i);
    Hyv(:, i) = Hxy(2:2:dim, i);

    Hx = reshape(Hxv(:,i), [Xpx, Ypx]);
    Hy = reshape(Hyv(:,i), [Xpx, Ypx]);
end



