load test1.mat

opt.max_it = 1000;
opt.lemda = 0.5;  % Step size of the velocity update
opt.sigma = 10; % Size of Gaussian smoothing
opt.beta = -0.2; % Parameter for the Penalty term
opt.alpha = 0.88; % Stencile of the penalty    
opt.multiRes = 0; % Scale of multi-resolution


[Mkxy, dX, dY] = register_ncc(source_img, target_img, msk1, opt);
result = interp2(double(source_img),dX,dY);
msk2 = interp2(msk1, dX, dY);

figure; imshow(result,[]); hold on;
contour(msk1*2-1,[0 0],'r'); hold off;

figure(100),imshow(source_img, []);hold on;
temp = msk2*2-1;
contour(temp,[0 0],'r'); hold off;


%%


target_img = ImgPatch_Cluster{1,3};
[BW] = WindowSeg(target_img);

figure; imshow(target_img,[]); hold on;
contour(BW*2-1,[0 0],'r'); hold off;



[Angle, Center] = ImageMoment(target_img2,ones(size(target_img2)));

figure; imshow(target_img2,[]); hold on;
plot(Center(1),Center(2),'rx'); hold off;


target_img3 = imrotate(target_img2,Angle,'nearest','crop');
figure; imshow(target_img3,[]);

