close all;
clear;

path(path,'Train Result');
path(path,'J:\To Andy\Segmentation\images\c6-c11');
path(path,'HelpFuncs');

%%% load the trained template files
load('c1.mat');

for i_idx = 6:11
    i_idx
filenamefmt = 'c%d.tif';
FileName = sprintf(filenamefmt,i_idx);
TestImg = imread(FileName);

[SeedPtMapRaw,RespMap,IdxMap] = Seed_Points_Detection2(TestImg,simulated_tp_cluster_all);
    
ratio = 0.50; % ratio value can be adjusted for better performance
th = max(RespMap(:))*ratio;
SeedPtMap = SeedPtMapRaw.*double(RespMap>=th);
    
%% show the results of detection by nxcorr2
%%% you can comment this part if threshold is selected
%%% or change the value of raio to see the detection result
[SeedPtRow,SeedPtCol] = find(SeedPtMap);
    
%%% show the centers of cell/nucleus detected
figure;
imshow(TestImg,[],'Border','tight');
hold on;
for i_pt = 1:length(SeedPtRow)
    plot(SeedPtCol(i_pt),SeedPtRow(i_pt),'rx');
end
hold off;

[SeedPtMapNew,Data_Cluster] = ...
    Detected_ImgPatch_Generator4(TestImg,SeedPtMap,simulated_tp_cluster_all);
    
fprintf('Start to refine the segmentation process.\n');
[Final_BW_Result] = FinalAccurateSeg(Data_Cluster);
    
%%% final results show and save
[SaveImgOutput,Final_Seg_Obj,Final_Seg_Msk] = Show_Final_Result2(TestImg,Final_BW_Result);
%%% show the estimated shapes of each detected cell/nucleus
% figure; imshow(SaveImgOutput,[]);%title('Final Segmentation Result');f('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));

[~, name, ~] = fileparts(FileName);
SaveFileName = [name '_output2.mat'];
save(SaveFileName,'SaveImgOutput','Final_Seg_Obj','Final_Seg_Msk','Data_Cluster','Final_BW_Result','SeedPtMapRaw','RespMap','IdxMap');
end