close all;
clear;

path(path,'Train Result');
path(path,'J:\To Andy\Segmentation\images\c1-c5');
path(path,'HelpFuncs');

%%% load the trained template files
load('c1-small.mat');

for i_idx = 1:1
    i_idx
filenamefmt = 'c%d.tif';
FileName = sprintf(filenamefmt,i_idx);
TestImg = imread(FileName);
TestImg = double(TestImg);
TestImg = TestImg/255;
TestImg = imresize(TestImg,0.5);

[SeedPtMapRaw,RespMap,IdxMap] = Seed_Points_Detection2(TestImg,simulated_tp_cluster_all2);
    
ratio = 0.50; % ratio value can be adjusted for better performance
th = max(RespMap(:))*ratio;
SeedPtMap = SeedPtMapRaw.*double(RespMap>=th);
    
%% show the results of detection by nxcorr2
%%% you can comment this part if threshold is selected
%%% or change the value of raio to see the detection result
[SeedPtRow,SeedPtCol] = find(SeedPtMap);
    
%%% show the centers of cell/nucleus detected
figure;
imshow(TestImg,[],'Border','tight');
hold on;
for i_pt = 1:length(SeedPtRow)
    plot(SeedPtCol(i_pt),SeedPtRow(i_pt),'rx');
end
hold off;

[SeedPtMapNew,Data_Cluster] = ...
    Detected_ImgPatch_Generator4(TestImg,SeedPtMap,simulated_tp_cluster_all2);

[~, name, ~] = fileparts(FileName);
SaveFileName1 = [name '_output1.mat'];
save(SaveFileName1);

    
fprintf('Start to refine the segmentation process.\n');
[Final_BW_Result] = FinalAccurateSeg(Data_Cluster);
    
%%% final results show and save
[SaveImgOutput,Final_Seg_Obj,Final_Seg_Msk,Final_Orig_Obj] = Show_Final_Result2(TestImg,Final_BW_Result);
%%% show the estimated shapes of each detected cell/nucleus
% figure; imshow(SaveImgOutput,[]);%title('Final Segmentation Result');f('Testing: %d%% Completed...[Image %d/%d]',floor(perc),i_img,ImgNum));


SaveFileName2 = [name '_output2.mat'];
save(SaveFileName2,'SaveImgOutput','Final_Seg_Obj','TestImg','','Final_Seg_Msk','Data_Cluster','Final_BW_Result','SeedPtMapRaw','RespMap','IdxMap');
end