function varargout = sample_select_interface(varargin)
% SAMPLE_SELECT_INTERFACE MATLAB code for sample_select_interface.fig
%      SAMPLE_SELECT_INTERFACE, by itself, creates a new SAMPLE_SELECT_INTERFACE or raises the existing
%      singleton*.
%
%      H = SAMPLE_SELECT_INTERFACE returns the handle to a new SAMPLE_SELECT_INTERFACE or the handle to
%      the existing singleton*.
%
%      SAMPLE_SELECT_INTERFACE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SAMPLE_SELECT_INTERFACE.M with the given input arguments.
%
%      SAMPLE_SELECT_INTERFACE('Property','Value',...) creates a new SAMPLE_SELECT_INTERFACE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before sample_select_interface_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to sample_select_interface_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help sample_select_interface

% Last Modified by GUIDE v2.5 07-Jun-2012 18:15:32

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @sample_select_interface_OpeningFcn, ...
                   'gui_OutputFcn',  @sample_select_interface_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before sample_select_interface is made visible.
function sample_select_interface_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to sample_select_interface (see VARARGIN)

% Choose default command line output for sample_select_interface
handles.output = hObject;
handles.directoryinfo = 'train images/*.tif'; % default directory
handles.trainfilesinfo = [];
handles.imgIdx = 0;
handles.FLAG = 1;
handles.samples = cell(1,1);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes sample_select_interface wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = sample_select_interface_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pre_image.
function pre_image_Callback(hObject, eventdata, handles)
% hObject    handle to pre_image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
imgIdx = handles.imgIdx;

if imgIdx==1
    fprintf('This is already the last image.\n');
else
    imgIdx = imgIdx-1;

    FileName = handles.trainfilesinfo(imgIdx,1).name;
    RawImg = imread(FileName);

    %%% note that we convert rgb images to grayscale images
    %%% and normalize the intensity range to [0,1]
    RawImgSz = size(RawImg);
    
    if length(RawImgSz)==3
%         OrigImg = double(rgb2gray(RawImg));
        OrigImg(:,:) = double((RawImg(:,:,2)));
        OrigImg = mat2gray(OrigImg);
    else
        OrigImg = mat2gray(double(RawImg));
    end

    [ImgPatch_Cluster,ShowMask] = Manual_Select_Patches(OrigImg);
    handles.samples{imgIdx,1} = ImgPatch_Cluster;
    handles.imgIdx = imgIdx;
    guidata(hObject,handles); 
end


% --- Executes on button press in next_image.
function next_image_Callback(hObject, eventdata, handles)
% hObject    handle to next_image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
imgIdx = handles.imgIdx;

if imgIdx==size(handles.trainfilesinfo,1)
    fprintf('This is already the last image.\n');
else
    imgIdx = imgIdx+1;

    FileName = handles.trainfilesinfo(imgIdx,1).name;
    RawImg = imread(FileName);

    %%% note that we convert rgb images to grayscale images
    %%% and normalize the intensity range to [0,1]
    RawImgSz = size(RawImg);
    
    if length(RawImgSz)==3
%         OrigImg = double(rgb2gray(RawImg));
        OrigImg(:,:) = double((RawImg(:,:,2)));
        OrigImg = mat2gray(OrigImg);
    else
        OrigImg = mat2gray(double(RawImg));
    end

    [ImgPatch_Cluster,ShowMask] = Manual_Select_Patches(OrigImg);
    handles.samples{imgIdx,1} = ImgPatch_Cluster;
    handles.imgIdx = imgIdx;
    guidata(hObject,handles); 
end



% --- Executes on button press in select_finish.
function select_finish_Callback(hObject, eventdata, handles)
% hObject    handle to select_finish (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[ImgPatch_Cluster] = CombineTpCluster(handles.samples);

fprintf('Totoally %d nuclei samples are selected.\n',length(ImgPatch_Cluster));

fprintf('Start to train the nuclei samples selected...\n');

ImgFileName = handles.trainfilesinfo(1,1).name;
MatFileName = [ImgFileName,'.tp_cluster.mat'];

[simulated_tp_cluster_all,MeanTp,MeanTpMsk] = PCA_Template_Generator(ImgPatch_Cluster);


save(MatFileName,'simulated_tp_cluster_all');

function train_file_info_Callback(hObject, eventdata, handles)
% hObject    handle to train_file_info (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of train_file_info as text
%        str2double(get(hObject,'String')) returns contents of train_file_info as a double

userinputdirectoryinfo = get(hObject,'String');

if isempty(userinputdirectoryinfo)
    fprintf('Since user does not input any file name, we use the default directory settings\n');
else
    directoryinfo = userinputdirectoryinfo;
end

handles.directoryinfo = directoryinfo;

trainfiles = dir(handles.directoryinfo);

if size(trainfiles,1)==0
    fprintf('There is no images in the input directory.\n');
else
    handles.trainfilesinfo = trainfiles;
    fprintf('Total %d train images loaded.\n',size(trainfiles,1));
end

[pathstr, name, ext] = fileparts(directoryinfo);

path(path,pathstr);

imgIdx = handles.imgIdx;
imgIdx = imgIdx+1;

FileName = handles.trainfilesinfo(imgIdx,1).name;
RawImg = imread(FileName);

%%% note that we convert rgb images to grayscale images
%%% and normalize the intensity range to [0,1]
RawImgSz = size(RawImg);
if length(RawImgSz)==3
%     OrigImg = double(rgb2gray(RawImg));
    OrigImg(:,:) = double((RawImg(:,:,2)));
    OrigImg = mat2gray(OrigImg);
else
    OrigImg = mat2gray(double(RawImg));
end

[ImgPatch_Cluster,ShowMask] = Manual_Select_Patches(OrigImg);

handles.samples{imgIdx,1} = ImgPatch_Cluster;
handles.imgIdx = imgIdx;

guidata(hObject,handles); 
    


% --- Executes during object creation, after setting all properties.
function train_file_info_CreateFcn(hObject, eventdata, handles)
% hObject    handle to train_file_info (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
