function [ImgPatch_Cluster,ShowMask,Seeds] = manualselectpatchesLine(OrigImg,handles,AllImg)

% function [ImgPatch_Cluster,ShowMask,BWs,Seeds] = manualselectpatchesLine(OrigImg,handles,AllImg)

fprintf('Start to crop the image patches from the whole image.\n');
ImgN=handles.imgIdx;
flag=false;
if (isempty(handles.Seeds{ImgN,1}))
    storedseeds={};
    
else
    storedseeds=handles.Seeds{ImgN,1};
    flag=true;
end

imgSz = size(OrigImg);
PatchCount = 0;
ImgPatch_Cluster = cell(1,1);
Seeds=cell(1,1);
ShowMask = uint8(mat2gray(OrigImg)*255);

KEY_IS_PRESSED=0;
str=['Cropping the Image ' num2str(ImgN) '/' num2str(AllImg)];

figure('Name',str);
imshow(OrigImg,'Border','tight');
if (flag)
    hold on;
    for i=1:size(storedseeds,2)
        plot(storedseeds{i}(1,1),storedseeds{i}(1,2),'rx');
    end
    hold off;
end
fprintf('If you want to stop selecting on the current image.\n');

while KEY_IS_PRESSED == 0
    
    KEY_IS_PRESSED = waitforbuttonpress;
    
    
    
    if KEY_IS_PRESSED==1
        break;
        
    else
        
        
        H= impoly;
        bw=createMask(H);
        setColor(H,[1 0 0]);
        
        [y_cor,x_cor]=find(bw>0);
        xmin=min(x_cor);
        ymin=min(y_cor);
        xmax=max(x_cor);
        ymax=max(y_cor);
        
        
        if xmin<=0
            xmin = 1;
        end
        if ymin<=0
            ymin = 1;
        end
        if xmax>=imgSz(2)
            xmax = imgSz(2)-1;
        end
        if ymax>=imgSz(1)
            ymax = imgSz(1)-1;
        end
        
        
        new_width = xmax-xmin+1;
        new_height = ymax-ymin+1;
        
        if mod(new_width,2)==0
            new_width = new_width+1;
        end
        if mod(new_height,2)==0
            new_height = new_height+1;
        end
        
        
        
        
        ImgPatch = zeros(new_height,new_width);
        temp=immultiply(OrigImg,bw);
        ImgPatch(1:new_height,1:new_width)=temp(ymin:ymin+new_height-1,xmin:xmin+new_width-1);
        
        BinaryContour = bwmorph(bw,'remove');
        BinaryContour = imdilate(BinaryContour,ones(5));
        
        ShowMask(BinaryContour) = 255;
        
        
        PatchCount = PatchCount+1;
        Seeds{1,PatchCount}=floor([(xmin+xmax)/2, (ymin+ymax)/2]);
        ImgPatch_Cluster{1,PatchCount} = ImgPatch;
        
%         BWs{PatchCount}=bw;
    end
end
hold off;
close;

