function [ImgPatch_Cluster,ShowMask,Seeds] = manualselectpatches(OrigImg,handles,AllImg)
fprintf('Start to crop the image patches from the whole image.\n');
ImgN=handles.imgIdx;
flag=false;
if (isempty(handles.Seeds{ImgN,1}))
    storedseeds={};
    
else
    storedseeds=handles.Seeds{ImgN,1};
    flag=true;
end
Seeds=cell(1,1);
imgSz = size(OrigImg);
PatchCount = 0;
ImgPatch_Cluster = cell(1,1);

[M,N,K] = size(OrigImg);

ShowMask = uint8(mat2gray(OrigImg)*255);

KEY_IS_PRESSED=0;
str=['Cropping the Image ' num2str(ImgN) '/' num2str(AllImg)];

figure('Name',str);
imshow(OrigImg,'Border','tight');
if (flag)
    hold on;
    for i=1:size(storedseeds,2)
        plot(storedseeds{i}(1,1),storedseeds{i}(1,2),'rx');
    end
    hold off;
end



fprintf('If you want to stop selecting on the current image.\n');

while KEY_IS_PRESSED == 0
    
    KEY_IS_PRESSED = waitforbuttonpress;
    
    
    
    if KEY_IS_PRESSED==1
        break;
        %         message = sprintf('Do you want to stop cropping patches?');
        %         reply = questdlg(message, 'Stop Cropping?', 'Yes','No', 'Yes');
        %
        %         if strcmpi(reply, 'Yes')
        %             % User canceled so exit.
        %             break;
        %
        %         else
        %         KEY_IS_PRESSED=0;
        %         end
        
    else
        H = imrect;
        position = wait(H);
        setColor(H,[1 0 0]);
        
        xmin = round(position(1));
        ymin = round(position(2));
        width = position(3);
        height = position(4);
        
        xmax = xmin+width-1;
        ymax = ymin+height-1;
        
        if xmin<=0
            xmin = 1;
        end
        if ymin<=0
            ymin = 1;
        end
        if xmax>=imgSz(2)
            xmax = imgSz(2)-1;
        end
        if ymax>=imgSz(1)
            ymax = imgSz(1)-1;
        end
        
        new_width = xmax-xmin+1;
        new_height = ymax-ymin+1;
        
        if mod(new_width,2)==0
            new_width = new_width+1;
        end
        if mod(new_height,2)==0
            new_height = new_height+1;
        end
        
        ImgPatch = zeros(new_height,new_width,K);
        ImgPatch(1:new_height,1:new_width,1:K) = ...
            OrigImg(ymin:ymin+new_height-1,xmin:xmin+new_width-1,1:K);
        
        BinaryMask = zeros(imgSz(1),imgSz(2));
        BinaryMask(ymin:ymin+new_height-1,xmin:xmin+new_width-1) = 1;
        BinaryContour = bwmorph(BinaryMask,'remove');
        BinaryContour = imdilate(BinaryContour,ones(5));
        
        ShowMask(BinaryContour) = 255;
        
        
        PatchCount = PatchCount+1;
        Seeds{1,PatchCount}=floor([(xmin+xmax)/2, (ymin+ymax)/2]);
        ImgPatch_Cluster{1,PatchCount} = ImgPatch;
    end
end
hold off;
close;

