function [local_sum_Img] = local_sum_tp(Img,tp)

% We thank Eli Horn for providing this code, used with his permission,
% to speed up the calculation of local sums. The algorithm depends on
% precomputing running sums as described in "Fast Normalized
% Cross-Correlation", by J. P. Lewis, Industrial Light & Magic.
% http://www.idiom.com/~zilla/Papers/nvisionInterface/nip.html

tpSz = size(tp);
offset1 = (tpSz(1)-1)/2;
offset2 = (tpSz(2)-1)/2;

imgSz = size(Img);
local_sum_Img = zeros(imgSz(1)+2*offset1,imgSz(2)+2*offset2);
ImgExt = padarray(Img,[2*offset1,2*offset2],'both');

for i_h = 1:imgSz(1)+2*offset1
    for j_w = 1:imgSz(2)+2*offset2
        imgwin = zeros(tpSz(1),tpSz(2));
        imgwin(1:tpSz(1),1:tpSz(2)) = ...
            ImgExt(i_h:i_h+2*offset1,j_w:j_w+2*offset2);
        
        Resp = imgwin.*tp;
        local_sum_Img(i_h,j_w) = sum(Resp(:));
    end
end







