function[modes, values] = eff_PCA2(A)
 
% Let A be a N*n matrix, N rows represent the observation
% n columns represent the variance.
% sometimes, N<<n
% Here we calculate the covariance matrix of input A, in order 
% calculate the eigen values and eigen vectors of the A*A'
% 
% The ultimate goal of doing so, is to use the optimized method 
% to compute PCA from A*A' (a N by N matrix) rather than 
% frome A'*A (a n by n matrix). Because the dimension n of the 
% variance is often much bigger than the observation N.
% 
% We can do so by:
% 1. Compute the eigVect and eigVal of the T = (D * D' )
%     Then we have T * eigVect = eigVal * eigVect;
% 2. We can compute the eigVect and eigVal of S = D' * D 
%     by D' * eigVect


% Step1 compute the eigVect and eigVal of the T = (D * D' )

[N, n] = size(A);
meanA = mean(A);
B = A - repmat(meanA, N,1); % mean is zero now
T = B*B'/(N-1);
[V, D] = eig(T);

%%% make the eigenvalues and its eigenvectors in descent order
eigenVect = fliplr(V);
eigenVal = flipud(diag(D));

% Step 2 compute A' * eigenVect, in order to calculate the eigenVect
% of the original covariance matrix

ampM = B'*eigenVect;

for i = 1:N
    modes(:,i) = ampM(:,i)/norm(ampM(:,i));  % make them norm = 1
    values(i) = eigenVal(i);
end
