%%% this is the main program for the cell segmentation system
%%% using the cross-correlation idea
%%% version 1.00 (05-27-2011)
%%% written by Cheng Chen (chengchen@cmu.edu)

close all; 
clear;

%% Section 1: Load the images
%%% the input image
path(path,'/Users/chengche/Dropbox/Codes/seed_points_cross_correlation');
load('PHS06-18469-1E-FEULGEN-FTClv-smaller.mat');

path(path,'/Users/chengche/Dropbox/Codes/cell_seg_xcorr_system/john_new_stain');
RawImg = imread('PHS04-12967AA-AGNOR-NFR-30-10-100X-1.tif');

%%% choose 4 slices for selecting nuclei candidates
ImgNum = 4;
patch_cluster_cell = cell(ImgNum,1);

for i_idx = 1:ImgNum
    RawImg = BinarySeg{2,i_idx};

    OrigImg = double(rgb2gray(RawImg));
    OrigImg = mat2gray(OrigImg);
    
    template_path = 'template_generate';
    path(path,template_path);
    [ImgPatches] = Manual_Select_Patches(OrigImg);
    patch_cluster_cell{i_idx,1} = ImgPatches;
end

[ImgPatch_Cluster] = CombineTpCluster(patch_cluster_cell);

[simulated_tp_cluster_all,MeanTp,MeanTpMsk] = PCA_Template_Generator(ImgPatch_Cluster);

%% Section 3: Seed Points Detection
%%% we calculate the cross-correlation to detect the seed points
%%% and the initial borders

seed_pt_path = 'seed_pt_detect';
path(path,seed_pt_path);

%%% comments: maybe I should add one function to search the optimal ones
% MeanMskInfo = regionprops(MeanTpMsk,'MinorAxisLength');
% RadiusLimited = round(MeanMskInfo.MinorAxisLength);

RadiusLimited = 70;
[SeedPtMapRaw,RespMap,IdxMap] = Seed_Points_Detection(OrigImg,simulated_tp_cluster_all,RadiusLimited);

ratio = 0.6;
th = max(RespMap(:))*ratio;
SeedPtMap = SeedPtMapRaw.*double(RespMap>=th);
[SeedPtRow,SeedPtCol] = find(SeedPtMap);

%% show the results of template matching

figure; 
imshow(OrigImg,[],'Border','tight');
hold on;
for i_pt = 1:length(SeedPtRow)
    plot(SeedPtCol(i_pt),SeedPtRow(i_pt),'rx');
end
hold off;


figure; imshow(RawImg,[],'Border','tight');
hold on;
for j_pt = 1:length(SeedPtRow)
    imgSz = size(OrigImg);
    CurrentIdx = SeedPtMap(SeedPtRow(j_pt),SeedPtCol(j_pt));
    CurrentTemplate = double(simulated_tp_cluster_all{2,CurrentIdx});
    templateSz = size(CurrentTemplate);
    offset1 = double(templateSz(1)-1)/2;
    offset2 = double(templateSz(2)-1)/2;
    
    InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
     
    InitialMapExt(SeedPtRow(j_pt):SeedPtRow(j_pt)+2*offset1,...
        SeedPtCol(j_pt):SeedPtCol(j_pt)+2*offset2) = ...
        CurrentTemplate(1:templateSz(1),1:templateSz(2));
    InitialMap(1:imgSz(1),1:imgSz(2)) = ...
        InitialMapExt(1+offset1:imgSz(1)+offset1,1+offset2:imgSz(2)+offset2);
    contour(InitialMap*2-1,[0 0],'b');    
end
hold off;

%% Section 4: Refine Segmentation
segment_path = 'refine_segment';
path(path,segment_path);

[SeedPtMapNew,Data_Cluster] = ...
    Detected_ImgPatch_Generator2(OrigImg,SeedPtMap,simulated_tp_cluster_all);

[Final_Result] = FinalRefineSeg(Data_Cluster);


%% Section 5: Final Result Show

figure;  
imshow(RawImg,'Border','tight');
hold on;
for j_pt = 1:size(Final_Result,1)
    
    if Final_Result{j_pt,3}==1 % for the single nucleus case 
        CenterX = Final_Result{j_pt,2}(2);
        CenterY = Final_Result{j_pt,2}(1);
    
        CurrentTemplate = Final_Result{j_pt,1};
        templateSz = size(CurrentTemplate);
        offset1 = double(templateSz(1)-1)/2;
        offset2 = double(templateSz(2)-1)/2;
    
        imgSz = size(RawImg);
    
        InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
     
        InitialMapExt(CenterY:CenterY+2*offset1,...
            CenterX:CenterX+2*offset2) = ...
        CurrentTemplate(1:templateSz(1),1:templateSz(2));
        InitialMap(1:imgSz(1),1:imgSz(2)) = ...
            InitialMapExt(1+offset1:imgSz(1)+offset1,1+offset2:imgSz(2)+offset2);
        contour(InitialMap*2-1,[0 0],'r');
    end
    
    if Final_Result{j_pt,3}>1 % for the multiple touching nuclei case
        PostInfo = Final_Result{j_pt,2};
        CurrentTemplate = Final_Result{j_pt,1};
        templateSz = size(CurrentTemplate);
        
        InitialMap = zeros(imgSz(1),imgSz(2));
     
        InitialMap(PostInfo(1):PostInfo(3),PostInfo(2):PostInfo(4)) = ...
            CurrentTemplate(1:templateSz(1),1:templateSz(2));
        
        contour(InitialMap*2-1,[0 0],'r');
    end
end
hold off;
title('The final segmentation result');







