function [tp_cluster_all] = Tp_RotateAndScale(tp_cluster)
%%% this function rotates each template to different orientations 
%%% and different scalings
%%% here we choose 7 orientations every 30 degrees
%%% and we choose 3 scales as the default settings
%%% written by Cheng Chen (chengchen@cmu.edu)

tpNum = size(tp_cluster,2);
tp_cluster_all = cell(2,1);
tp_count = 0;

for i_tp = 1:tpNum
    
    tp_img = full(tp_cluster{1,i_tp});
    tp_msk = double(tp_cluster{2,i_tp});
    
    STATS = regionprops(tp_msk,'BoundingBox','Centroid','Orientation');
    CenterInfo = STATS.Centroid;
    OrientInfo = STATS.Orientation;
            
    [tpH,tpW] = size(tp_img);
    [tpX,tpY] = meshgrid(1:tpW,1:tpH);
    tpX = tpX-CenterInfo(1);
    tpY = tpY-CenterInfo(2);
    
    for j_angle = -3:3
        if OrientInfo>=0
            rotate_angle = ((OrientInfo-90)+(30*j_angle))*pi/180;
        else
            rotate_angle = ((30*j_angle)+(90+OrientInfo))*pi/180;
        end
    
        tpX2 = tpX.*cos(rotate_angle)+tpY.*sin(rotate_angle);
        tpY2 = -tpX.*sin(rotate_angle)+tpY.*cos(rotate_angle);
    
        ZI_Img = interp2(tpX,tpY,tp_img,tpX2,tpY2);
        ZI_Msk = interp2(tpX,tpY,tp_msk,tpX2,tpY2,'nearest');
        
        ZI_Msk = NaNFix(ZI_Msk);
        ZI_Img = NaNFix(ZI_Img);
        
        [ZI_Img2,ZI_Msk2] = AdaptiveTp(ZI_Img,ZI_Msk);
             
        for k_scale = 0:0% -1:1
            scale = (1+k_scale/5);
            tp_H = round(size(ZI_Img2,1)*scale);
            tp_W = round(size(ZI_Img2,2)*scale);
            
            if mod(tp_H,2)==0
                tp_H = tp_H+1;
            end
            
            if mod(tp_W,2)==0
                tp_W = tp_W+1;
            end

            ZI_Img_S = imresize(ZI_Img2,[tp_H tp_W]);
            ZI_Msk_S = imresize(ZI_Msk2,[tp_H tp_W],'nearest');
                        
            tp_count = tp_count+1;
        
            tp_cluster_all{1,tp_count} = sparse(ZI_Img_S);
            tp_cluster_all{2,tp_count} = logical(ZI_Msk_S);
        end
    end
end