function [simulated_tp] = Simulated_Shape_PCA_New(MeanTp,MeanTpMsk,MeanPatchMsk,tp_cluster,opt)

%%% the parameters settings
% opt.sigma = 35; %std of basis function for modeling deformations
% opt.sigma_i = 2; %std of basis functions for computing image derivatives
% opt.max_pix_displacement = 2; %maximum pixel displacement in one gradient descent iteration
% opt.n_stepsizes = 5; %number of step sizes to try within one gradient descent iteration
% opt.max_iterations = 200; %maximum number of gradient descent iterations to use
% opt.tolerance = 10^(-5); %smallest acceptable improvement in each iteration

tpNum = size(tp_cluster,2);

for i_tp = 1:tpNum
    target_img = double(tp_cluster{1,i_tp});
    target_patchmsk = double(tp_cluster{2,i_tp});
    
    %%% dX and dY are the deformed coordinates of pixels in MeanTp
    CommonMsk = MeanPatchMsk(:,:,1);
    [Mkxy, dX, dY, current_ncc] = ...
            nr_ncc2(target_img, MeanTp, CommonMsk, CommonMsk, opt);
        
%     [Mkxy, dX, dY, current_ncc] = ...
%         nr_ncc3(target_img.*target_patchmsk, MeanTp.*MeanPatchMsk, opt);
    
    def_X(:,:,i_tp) = dX(:,:);
    def_Y(:,:,i_tp) = dY(:,:);
end

disp('Doing PCA on the deformation transformations. Please wait ...');
xh_vec = ImgsToVectors(def_X);
yh_vec = ImgsToVectors(def_Y);
Hxy_vec =  vectorCombine(xh_vec, yh_vec);

[Modes, latent] = eff_PCA2(Hxy_vec');
HxyBar = mean(Hxy_vec,2);

PrinCompIdx = find(latent>0.1);

%%% automatically select the number of components
%%% the criteria is to cover totally 95% variances
SelectPrinComp = 0;
UsefulVariance = 0;

for i_comp = 1:length(PrinCompIdx)
    if UsefulVariance<sum(latent(:))*0.95 % we cover 95% total variances
        UsefulVariance = UsefulVariance+latent(i_comp);
        SelectPrinComp = SelectPrinComp+1;
    end
end
%%
tpCount = 0;
simulated_tp = cell(2,1);

for i_b = 1:SelectPrinComp
    i_b
    for b_comp = -2:2
        b_value = (b_comp)*(latent(i_b)^0.5);    
        [MODEL,MSK] = ...
            GSM_PCA_New(b_value, Modes, HxyBar, MeanTp, MeanTpMsk, MeanPatchMsk, i_b, opt);
        tpCount = tpCount+1;
        simulated_tp{1,tpCount} = (MODEL);
        simulated_tp{2,tpCount} = logical(MSK);
    end
end

%%% the following are for test purpose
% i_idx = 1;
% [DeformedTp,DeformedMsk] = GSM_PCA(-2*latent(i_idx)^0.5, Modes, HxyBar, MeanTp, MeanTpMsk, i_idx, opt);
% 
% figure; 
% subplot(1,2,1);
% imshow(MeanTpMsk,[]); hold on;
% contour(DeformedMsk*2-1,[0 0],'r'); hold off;
% subplot(1,2,2);
% imshow(DeformedTp,[]); hold on;
% contour(DeformedMsk*2-1,[0 0],'r'); hold off;
% title('the second component with -3\times sigma');

