function [simulated_tp] = Simulated_Shape_PCA(MeanTp,MeanTpMsk,tp_cluster)

%%% the parameters settings
% opt.max_it = 100; %maximum number of iterations in one resolution
% opt.lambda = 50000;  % Step size of the velocity update
% opt.sigma = 2; % Size of Gaussian smoothing for images
% opt.sigma_p = 1; % Size of Gaussian for smoothing deformation field
% opt.multiRes = 2; %number of multiple resolutions (minus 1)

opt.max_it = 400; %maximum number of iterations in one resolution
opt.lambda = 50000;  % Step size of the velocity update
opt.sigma_p = 1.5; % Size of Gaussian for smoothing deformation field
opt.multiRes = 2; %number of multiple resolutions (minus 1)

tpNum = size(tp_cluster,2);

for i_tp = 1:tpNum
    target_img = double(tp_cluster{1,i_tp});
    
    %%% dX and dY are the deformed coordinates of pixels in MeanTp
    [Mkxy, dX, dY] = register_ncc_v3(target_img, MeanTp, opt);
    def_X(:,:,i_tp) = dX(:,:);
    def_Y(:,:,i_tp) = dY(:,:);
    
%     TempImg = interp2(double(target_img),double(dX),double(dY));
%     
%     figure;
%     imagesc(TempImg); colormap gray; axis off; axis equal; hold on;
%     plot(dX(:,1:10:size(dX,2)),dY(:,1:10:size(dX,2)),'g');
%     plot(dX(1:10:size(dX,1),:)',dY(1:10:size(dX,1),:)','g');
%     hold off;
%     
%     figure; imagesc(MeanTp); colormap gray; axis off; axis equal;
%     pause;
end

disp('Doing PCA on the deformation transformations. Please wait ...');
xh_vec = ImgsToVectors(def_X);
yh_vec = ImgsToVectors(def_Y);
Hxy_vec =  vectorCombine(xh_vec, yh_vec);

[Modes, latent] = eff_PCA2(Hxy_vec');
HxyBar = mean(Hxy_vec,2);

PrinCompIdx = find(latent>0.1);

%%% automatically select the number of components
%%% the criteria is to cover totally 95% variances
SelectPrinComp = 0;
UsefulVariance = 0;

for i_comp = 1:length(PrinCompIdx)
    if UsefulVariance<sum(latent(:))*0.95 % we cover 95% total variances
        UsefulVariance = UsefulVariance+latent(i_comp);
        SelectPrinComp = SelectPrinComp+1;
    end
end

tpCount = 0;
simulated_tp = cell(2,1);

for i_b = 1:SelectPrinComp
    i_b
    for b_comp = -2:2
        b_value = (b_comp)*(latent(i_b)^0.5);    
        [MODEL,MSK] = GSM_PCA(b_value, Modes, HxyBar, MeanTp, MeanTpMsk, i_b, opt);
        tpCount = tpCount+1;
        simulated_tp{1,tpCount} = sparse(MODEL);
        simulated_tp{2,tpCount} = logical(MSK);
    end
end

%%% the following are for test purpose
% i_idx = 1;
% [DeformedTp,DeformedMsk] = GSM_PCA(-2*latent(i_idx)^0.5, Modes, HxyBar, MeanTp, MeanTpMsk, i_idx, opt);
% 
% figure; 
% subplot(1,2,1);
% imshow(MeanTpMsk,[]); hold on;
% contour(DeformedMsk*2-1,[0 0],'r'); hold off;
% subplot(1,2,2);
% imshow(DeformedTp,[]); hold on;
% contour(DeformedMsk*2-1,[0 0],'r'); hold off;
% title('the second component with -3\times sigma');

