function [SaveImgOutput,SegObjCluster,SegMskCluster,OrigObjCluster] = Show_Final_Result2(TestImg,Final_Result)
%%% this function is to show the segmented contours in the original image
%%% and provide the image to write to the disk
%%% written by Cheng Chen (chengchen@cmu.edu)

imgSz = size(TestImg);
TestImg2 = uint8(mat2gray(double(TestImg))*255);
StdTpSz = [511,511]; % standard template size
StdOffset1 = (StdTpSz(1)-1)/2;
StdOffset2 = (StdTpSz(2)-1)/2;

if length(imgSz)==2 % grayscale image
    SaveImg = zeros(imgSz(1),imgSz(2),3);
    SaveImg(:,:,1) = TestImg2(:,:);
    SaveImg(:,:,2) = TestImg2(:,:);
    SaveImg(:,:,3) = TestImg2(:,:);
    SaveImg = uint8(SaveImg);
    GrayImg = TestImg2;
else % rgb image
    SaveImg = TestImg2;    
    GrayImg = rgb2gray(TestImg2);
    GrayImg = uint8(mat2gray(double(GrayImg))*255);
end

OrigObjCluster = zeros(StdTpSz(1),StdTpSz(2),1);
SegObjCluster = zeros(StdTpSz(1),StdTpSz(2),1);
SegMskCluster = zeros(StdTpSz(1),StdTpSz(2),1);

ObjCount = 0;
RawImg = TestImg;

for j_pt =1:size(Final_Result,1)
    j_pt
    if Final_Result{j_pt,3}==1 % for the single nucleus case 
        CenterX = Final_Result{j_pt,2}(2);
        CenterY = Final_Result{j_pt,2}(1);
    
        CurrentTemplate = Final_Result{j_pt,1};
        templateSz = size(CurrentTemplate);
        
        offset1 = double(templateSz(1)-1)/2;
        offset2 = double(templateSz(2)-1)/2;
    
        InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
     
        InitialMapExt(CenterY:CenterY+2*offset1,...
            CenterX:CenterX+2*offset2) = ...
            CurrentTemplate(1:templateSz(1),1:templateSz(2));
        
        InitialMap(1:imgSz(1),1:imgSz(2)) = ...
            InitialMapExt(1+offset1:imgSz(1)+offset1,1+offset2:imgSz(2)+offset2);
        
        BorderMap = bwmorph(InitialMap,'remove',4);
        BorderMap = bwmorph(BorderMap,'diag');
        BorderMap = bwmorph(BorderMap,'dilate');
        
        [BorderRow,BorderCol] = find(BorderMap>0);
    
        for j_bd = 1:length(BorderRow)
            SaveImg(BorderRow(j_bd),BorderCol(j_bd),1) = 0;
            SaveImg(BorderRow(j_bd),BorderCol(j_bd),2) = 0;
            SaveImg(BorderRow(j_bd),BorderCol(j_bd),3) = 255;
        end
        
        RawImgMsk = double(GrayImg).*InitialMap;
        RawImgMskExt = padarray(RawImgMsk,[StdOffset1,StdOffset2],'both');
        
        RawImgMsk2 = double(GrayImg);
        RawImgMskExt2 = padarray(RawImgMsk2,[StdOffset1,StdOffset2],'both');
        
               
        if sum(InitialMap(:))==0
            continue;
        end
        
        STATS = regionprops(InitialMap,'Centroid');
        
        NucleiMsk = zeros(StdTpSz);
        Nuclei_H = round(STATS.Centroid(2));
        Nuclei_W = round(STATS.Centroid(1));
        NucleiMsk(1:StdTpSz(1),1:StdTpSz(2)) = ...
            RawImgMskExt(Nuclei_H:Nuclei_H+2*StdOffset1,Nuclei_W:Nuclei_W+2*StdOffset2);
        
        NucleiMsk2 = zeros(StdTpSz);
        NucleiMsk2(1:StdTpSz(1),1:StdTpSz(2)) = ...
            RawImgMskExt2(Nuclei_H:Nuclei_H+2*StdOffset1,Nuclei_W:Nuclei_W+2*StdOffset2);
        
        ObjCount = ObjCount+1;
        SegObjCluster(:,:,ObjCount) = NucleiMsk(:,:);
        OrigObjCluster(:,:,ObjCount) = NucleiMsk2(:,:);
        
        BinaryMsk = double(NucleiMsk>0);
        BinaryMsk = double(imfill(BinaryMsk,'holes'));
        SegMskCluster(:,:,ObjCount) = BinaryMsk;
    end
    
    if Final_Result{j_pt,3}>1 % for the multiple touching nuclei case
        PostInfo = Final_Result{j_pt,2};
        CurrentTemplate = Final_Result{j_pt,1};
        templateSz = size(CurrentTemplate);
                   
        
        InitialMap = zeros(imgSz(1),imgSz(2));
     
        InitialMap(PostInfo(1):PostInfo(3),PostInfo(2):PostInfo(4)) = ...
            CurrentTemplate(1:templateSz(1),1:templateSz(2));
        
        BorderMap = bwmorph(InitialMap,'remove',4);
        BorderMap = bwmorph(BorderMap,'diag');
        BorderMap = bwmorph(BorderMap,'dilate');
        
        [BorderRow,BorderCol] = find(BorderMap>0);
    
        for j_bd = 1:length(BorderRow)
            SaveImg(BorderRow(j_bd),BorderCol(j_bd),1) = 0;
            SaveImg(BorderRow(j_bd),BorderCol(j_bd),2) = 0;
            SaveImg(BorderRow(j_bd),BorderCol(j_bd),3) = 255;
        end
        
        %%% add the segmented nucleus into array
        RawImgMsk = double(GrayImg).*InitialMap;
        RawImgMskExt = padarray(RawImgMsk,[StdOffset1,StdOffset2],'both');
        
        RawImgMsk2 = double(GrayImg);
        RawImgMskExt2 = padarray(RawImgMsk2,[StdOffset1,StdOffset2],'both');
        
        if sum(InitialMap(:))==0
            continue;
        end
        
        STATS = regionprops(InitialMap,'Centroid');
        
        NucleiMsk = zeros(StdTpSz);
    
        Nuclei_H = round(STATS.Centroid(2));
        Nuclei_W = round(STATS.Centroid(1));
        NucleiMsk(1:StdTpSz(1),1:StdTpSz(2)) = ...
            RawImgMskExt(Nuclei_H:Nuclei_H+2*StdOffset1,Nuclei_W:Nuclei_W+2*StdOffset2);
        
        NucleiMsk2 = zeros(StdTpSz);
        NucleiMsk2(1:StdTpSz(1),1:StdTpSz(2)) = ...
            RawImgMskExt2(Nuclei_H:Nuclei_H+2*StdOffset1,Nuclei_W:Nuclei_W+2*StdOffset2);
        
        ObjCount = ObjCount+1;
        SegObjCluster(:,:,ObjCount) = NucleiMsk(:,:);
        OrigObjCluster(:,:,ObjCount) = NucleiMsk2(:,:);
        
        BinaryMsk = double(NucleiMsk>0);
        BinaryMsk = double(imfill(BinaryMsk,'holes'));
        SegMskCluster(:,:,ObjCount) = BinaryMsk;
    end
end

SaveImgOutput = SaveImg;