function [SeedPtMapRaw,RespMap,IdxMap] = Seed_Points_Detection3(OrigImg,tp_cluster)
%%% the function is to use cross-correlation to detect seed points
%%% note that we only process 2D images here
%%% written by Cheng Chen (chengchen@cmu.edu)

imgSz = size(OrigImg);
IdxMap = zeros(imgSz(1),imgSz(2));
RespMap = ones(imgSz(1),imgSz(2))*(-10);

%% perform 2d cross-correlation and crop extra regions from coeff matrix
%%% the normalized response will be from -1 to +1
%%% First, extend the original image to prevent border problem

for i_tp = 1:length(tp_cluster)
    fprintf('Now calculate the cross-correlation of the %dth template\n',i_tp);
    template = full(tp_cluster{1,i_tp});
    templateSz = size(template);
    offset1 = double(templateSz(1)-1)/2;
    offset2 = double(templateSz(2)-1)/2;
    
    OrigImgExt = padarray(OrigImg,[offset1,offset2],'replicate','both');
    
    %%% build the template
%     resp_ext = normxcorr2(template,OrigImgExt);
    Msk = double(tp_cluster{3,i_tp});
    template2 = Msk.*template;
    resp_ext = normxcorr2_rotate(template2,OrigImgExt,Msk);
    cc_cut = resp_ext(2*offset1+1:2*offset1+imgSz(1),...
        2*offset2+1:2*offset2+imgSz(2));
    
    A(:,:,1) = RespMap(:,:); % the existing responses
    A(:,:,2) = cc_cut; % the new responses
    
    [B,IX] = sort(A,3,'descend');
    IX1(:,:) = IX(:,:,1);
    
    LargerResp(:,:) = B(:,:,1);
    RespMap = LargerResp;
    
    IdxMap = IdxMap.*double(IX1==1)+double(ones(imgSz(1),imgSz(2))*i_tp).*double(IX1==2);
end

%% detect the seeds
%%% re-sort the response vector in descend order

RespVector = reshape(RespMap,imgSz(1)*imgSz(2),1);
PtNum = imgSz(1)*imgSz(2);
[XI,YI] = meshgrid(1:imgSz(2),1:imgSz(1));
YIVector = reshape(YI,imgSz(1)*imgSz(2),1);
XIVector = reshape(XI,imgSz(1)*imgSz(2),1);
LocationVector(:,1) = YIVector(:,1);
LocationVector(:,2) = XIVector(:,1);

[RespVectorSorted,IXSorted] = sort(RespVector,'descend');
SeedPtMapRaw = zeros(imgSz(1),imgSz(2));
AreaMap = zeros(imgSz(1),imgSz(2));

for i_pt = 1:PtNum
    i_pt
    currentIdx = IXSorted(i_pt);
    currentY = LocationVector(currentIdx,1);
    currentX = LocationVector(currentIdx,2);
    
    if AreaMap(currentY,currentX)==0
        SeedPtMapRaw(currentY,currentX) = IdxMap(currentY,currentX); 
        TpMsk = double(tp_cluster{2,IdxMap(currentY,currentX)});
                
        offset1 = (size(TpMsk,1)-1)/2;
        offset2 = (size(TpMsk,2)-1)/2;
        
        RegionMapExt = zeros(imgSz(1)+2*offset1,imgSz(2)+2*offset2);
        RegionMapExt(currentY:currentY+2*offset1,currentX:currentX+2*offset2) = ...
            TpMsk(1:1+2*offset1,1:1+2*offset2);
        RegionMap(1:imgSz(1),1:imgSz(2)) = ...
            RegionMapExt(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
        
        XI2 = XI-currentX;
        YI2 = YI-currentY;
        
        XI3 = XI2*0.7;
        YI3 = YI2*0.7;
        
        RegionMap2 = interp2(XI2,YI2,RegionMap,XI3,YI3,'nearest');
%         STATS = regionprops(RegionMap2, 'MajorAxisLength','MinorAxisLength');
%         STATS.MajorAxisLength
%         STATS.MinorAxisLength
%         pause
%         figure; imshow(RegionMap2,[]); pause;
        
        AreaMap = AreaMap+RegionMap2;
    end
end