function [RtImg] = RigidTransformation(Img1, Center1, theta, Tx, Ty, Img2)
%%% the function RigidTransformation is to implement rigid transformation
%%% from Img1 to Img2, given three parameters: theta, Tx, Ty
%%% The positive theta value means the rotation direction is clock-wise 
%%% written by Cheng Chen (chengchen@cmu.edu)

ImgSz = size(Img1);

if size(ImgSz, 2) == 3
    if ImgSz(3) == 3
        Img1 = rgb2gray(Img1);
    end
end
Img1 = double(Img1);
centerX1 = Center1(1);
centerY1 = Center1(2);

centerX2 = centerX1 + Tx;
centerY2 = centerY1 + Ty;

ImgSz1 = size(Img1);
ImgSz2 = size(Img2);

theta = theta*pi/180;

[ImgX1, ImgY1] = meshgrid(1-centerX1 : ImgSz1(2)-centerX1, -(1-centerY1) :-1:-(ImgSz1(1)-centerY1));
[ImgX2, ImgY2] = meshgrid(1-centerX2 : ImgSz2(2)-centerX2, -(1-centerY2) :-1:-(ImgSz2(1)-centerY2));
 
ImgX2_new = ImgX2*cos(theta) + ImgY2*sin(-theta);
ImgY2_new = ImgX2*sin(theta) + ImgY2*cos(theta);
clear ImgX2 ImgY2;  
RtImg = interp2(ImgX1, ImgY1, Img1, ImgX2_new, ImgY2_new);
 
Lbl = double(isnan(RtImg));
RtImg(Lbl == 1) = 255;