function [simulated_tp_cluster_all] = Real_Template_Generator2(ImgPatch_Cluster)
%%% this function is to produce the simulated templates based on the real
%%% image patches
%%% written by Cheng Chen (chengchen@cmu.edu)

%%% step 1: we choose the max height and width to select the size of 
%%% the standard template
PatchNum = size(ImgPatch_Cluster,2);
tp_cluster = cell(1,PatchNum);
maxH = 0;
maxW = 0;

for i_patch = 1:PatchNum
    one_patch = ImgPatch_Cluster{i_patch};
    PatchSz = size(one_patch);
    if PatchSz(1)>maxH
        maxH = PatchSz(1);
    end
    if PatchSz(2)>maxW
        maxW = PatchSz(2);
    end
end

%%% actually, we increase the size of template a little bit
offsetH = round(((maxH-1)/2)*1.5);
offsetW = round(((maxW-1)/2)*1.5);

%%% step 2: randomly choose one to build a standard template

special_idx = mod(ceil(100.*rand(1,1)),PatchNum)+1; % randomly produce idx
special_patch = ImgPatch_Cluster{special_idx};

[Angle, Center] = ImageMoment(special_patch);
PatchSz = size(special_patch);
[patchX,patchY] = meshgrid(1:PatchSz(2),1:PatchSz(1));
patchX = patchX-Center(1);
patchY = patchY-Center(2);
[tpX,tpY] = meshgrid(-offsetW:offsetW,-offsetH:offsetH);
ZI = interp2(patchX,patchY,special_patch,tpX,tpY);

[D,L] = bwdist(~isnan(ZI));
ZI2 = zeros(size(ZI));
    
for j_height=1:size(ZI,1)
    for k_width=1:size(ZI,2)
        LLL = L(j_height,k_width);
        LLL_Y = mod(LLL,size(ZI,1));
        if LLL_Y==0
            LLL_Y = size(ZI,1);
        end
        LLL_X = (LLL-LLL_Y)/size(ZI,1)+1;
        ZI2(j_height,k_width) = ...
            ZI(LLL_Y,LLL_X);
    end
end

special_tp = ZI2; % the special_tp is the initial standard template


%%% step 3: first, we do a rigid-registration, move the center of mass at
%%% the center of the standard template, and rotate the orientation to be
%%% vertical, this could make the following registration to be accurate

for i_patch = 1:PatchNum
    i_patch
    one_patch = ImgPatch_Cluster{i_patch};
    [ImgTp] = ImgRigidAlignment(special_tp,one_patch);
    figure; imshow(ImgTp,[]); 
    tp_cluster{i_patch} = ImgTp;
end

%%% step 4: calculate the mean image as the initial template
%%% here, we just choose one image for test use
InitTp = tp_cluster{special_idx};

[MeanTp] = MeanImgTemplate(tp_cluster,InitTp);
[MeanTpMsk] = ManualSeg_LevelSet(MeanTp);

figure; imshow(MeanTp,[]); hold on;
contour(MeanTpMsk*2-1,[0 0],'r'); hold off; 
title('standard template and its mask');

%%% step 6: start to use PCA method to generate different shapes
opt.max_it = 1000;
opt.lemda = 0.5;  % Step size of the velocity update
opt.sigma = 10; % Size of Gaussian smoothing
opt.beta = -0.2; % Parameter for the Penalty term
opt.alpha = 0.88; % Stencile of the penalty    
opt.multiRes = 0;

[MeanMskRow,MeanMskCol] = find(MeanTpMsk>0);
ControlPtMesh = zeros(PatchNum,2*length(MeanMskRow));

for i_patch = 1:PatchNum
    target_img = tp_cluster{i_patch};
    [Mkxy, dX, dY] = register_ncc(MeanTp, target_img, ones(size(MeanTp)), opt);
    TransMskMesh = zeros(2*length(MeanMskRow),1);
    
    for j_pt = 1:length(MeanMskRow)
        TransMskMesh(2*j_pt-1) = dX(MeanMskRow(j_pt),MeanMskCol(j_pt));
        TransMskMesh(2*j_pt) = dY(MeanMskRow(j_pt),MeanMskCol(j_pt));
    end
    
    ControlPtMesh(i_patch,1:2*length(MeanMskRow)) = ...
        TransMskMesh(1:2*length(MeanMskRow),1);    
end

AveMskMesh = sum(ControlPtMesh,1)/PatchNum;
[COEFF,SCORE,latent] = princomp(ControlPtMesh);
PrinCompIdx = find(latent>0.1);

%%% automatically select the number of components
%%% the criteria is to include 95% variances
SelectPrinComp = 0;
UsefulVariance = 0;

for i_comp = 1:length(PrinCompIdx)
    if UsefulVariance<sum(latent(:))*0.95
        UsefulVariance = UsefulVariance+latent(i_comp);
        SelectPrinComp = SelectPrinComp+1;
    end
end

%%% start to generate simulated shapes
P = zeros(size(COEFF,1),SelectPrinComp);
P(1:size(COEFF,1),1:SelectPrinComp) = COEFF(1:size(COEFF,1),1:SelectPrinComp);

%%% choose different values of b to produce different shapes
StepNum = 3;
StepOffset = (StepNum-1)/2;
simulated_tp_cluster = cell(2,1);
tpCount = 0;
AllSet = -StepOffset:StepOffset;
AllSet = repmat(AllSet,1,SelectPrinComp);
combos = combntns(AllSet,SelectPrinComp);
combos2 = unique(combos,'rows');

for i_b = 1:size(combos2,1)                  
    b = zeros(SelectPrinComp,1);
    for j_comp = 1:SelectPrinComp
        b(j_comp) = (2.5*combos2(i_b,j_comp))*(latent(j_comp)^0.5);    
    end
    
    NewMskMesh = AveMskMesh'+P*b;
    NewRawMsk = zeros(size(MeanTp));

    for i_pt = 1:length(MeanMskRow)
        FDD_x(i_pt) = double(NewMskMesh(2*i_pt-1));
        FDD_y(i_pt) = double(NewMskMesh(2*i_pt));
    
        NewRawMsk(floor(FDD_y(i_pt)),floor(FDD_x(i_pt))) = 1;
        NewRawMsk(floor(FDD_y(i_pt)),ceil(FDD_x(i_pt))) = 1;
        NewRawMsk(ceil(FDD_y(i_pt)),floor(FDD_x(i_pt))) = 1;
        NewRawMsk(ceil(FDD_y(i_pt)),ceil(FDD_x(i_pt))) = 1;
    end
    NewRawMsk = double(bwmorph(NewRawMsk,'bridge'));

    [Mkxy, dX, dY] = register_ncc(NewRawMsk, MeanTpMsk, MeanTpMsk, opt);
    NewTpMsk = interp2(MeanTpMsk, dX, dY,'nearest');
    NewTp = interp2(MeanTp,dX,dY);
    
%     figure; imshow(NewRawMsk,[]); hold on; contour(NewTpMsk*2-1,[0 0],'r'); hold off;
%     figure; imshow(NewTp,[]); hold on; contour(NewTpMsk*2-1,[0 0],'r'); hold off; pause;
    
    tpCount = tpCount+1;
    
    simulated_tp_cluster{1,tpCount} = sparse(NewTp);
    simulated_tp_cluster{2,tpCount} = logical(NewTpMsk);   
end

[simulated_tp_cluster_all] = RotateAndScale(simulated_tp_cluster);



