function [YUV] = RGB2YUV(RGB)

a = RGB;
r=a(:,:,1);
g=a(:,:,2);
b=a(:,:,3);

wr=0.2126;
wb=0.0722;
wg=1-wr-wb;

umax=0.436;
vmax=0.615;
Y = wr*r +wg*g+wb*b;
U = umax*((b-Y)/(1-wb));
V = vmax*((r-Y)/(1-wr));

YUV(:,:,1) = Y(:,:);
YUV(:,:,2) = U(:,:);
YUV(:,:,3) = V(:,:);