function [simulated_tp_cluster_all,MeanTp,MeanTpMsk] = ...
    PCA_Template_Generator_New(ImgPatch_Cluster)
%%% this function is to produce the simulated templates based on the real
%%% image patches
%%% written by Cheng Chen (chengchen@cmu.edu)

%%% step 1: we choose the max height and width among sample patches selected
%%% to select the size of the standard template
[M,N,K] = size(ImgPatch_Cluster{1,1});

PatchNum = size(ImgPatch_Cluster,2);
tp_cluster = cell(2,PatchNum);
maxH = 0;
maxW = 0;

for i_patch = 1:PatchNum   
    one_patch = ImgPatch_Cluster{i_patch};
    PatchSz = size(one_patch);
    
    if PatchSz(1)>maxH
        maxH = PatchSz(1);
    end
    if PatchSz(2)>maxW
        maxW = PatchSz(2);
    end
end

%%% actually, we increase the size of template a little bit
%%% and finalize the standard size of templates
offsetH = round(((maxH-1)/2)*1.5);
offsetW = round(((maxW-1)/2)*1.5);

%%% step 2: randomly choose one nuclei sample to build a standard template
special_idx = mod(ceil(100.*rand(1,1)),PatchNum)+1; % randomly produce idx

special_patch = ImgPatch_Cluster{special_idx};
[Angle, Center] = ImageMoment(special_patch);

PatchSz = size(special_patch);
[patchX,patchY] = meshgrid(1:PatchSz(2),1:PatchSz(1));
patchX = patchX-Center(1);
patchY = patchY-Center(2);
[tpX,tpY] = meshgrid(-offsetW:offsetW,-offsetH:offsetH);

special_tp = zeros(2*offsetH+1,2*offsetW+1,K);

for i_channel = 1:K
    ZI = interp2(patchX,patchY,special_patch(:,:,i_channel),tpX,tpY);
    [special_tp_onechannel] = NaNFix(ZI); % the special_tp is the initial standard template
    special_tp(:,:,i_channel) = special_tp_onechannel(:,:);
end

%%% step 3: first, we do a rigid-registration, move the center of mass at
%%% the center of the standard template, and rotate the orientation to be
%%% vertical, this could make the following registration to be accurate
fprintf('The first step: rigid alignment between sample patches.\n');

for i_patch = 1:PatchNum   
    i_patch
    one_patch = ImgPatch_Cluster{i_patch};
    [ImgTp,ImgPatchMsk] = ImgRigidAlignment_New(special_tp,one_patch);
    tp_cluster{1,i_patch} = ImgTp;
    tp_cluster{2,i_patch} = ImgPatchMsk;
end

%%% step 4: calculate the mean image as the initial template
fprintf('The second step: calculate the mean template of samples.\n');
InitTp = tp_cluster{1,special_idx};
InitPatchMsk = tp_cluster{2,special_idx};

opt.sigma = 15;%35; %std of basis function for modeling deformations
opt.sigma_i = 2; %std of basis functions for computing image derivatives
opt.max_pix_displacement = 2; %maximum pixel displacement in one gradient descent iteration
opt.n_stepsizes = 5; %number of step sizes to try within one gradient descent iteration
opt.max_iterations = 200; %maximum number of gradient descent iterations to use
opt.tolerance = 10^(-5); %smallest acceptable improvement in each iteration

[MeanTp] = ...
    MeanImgTemplate_New(tp_cluster, InitTp, InitPatchMsk, opt);

%%% step 5: segment the mean template via either manual or auto methods

reply = 'N';

while reply~='Y'
    [MeanTpMsk,MeanPatchMsk] = CreateMeanTpMsk(MeanTp);
    
    message = sprintf('Do you satisfy with current result?');
    reply = questdlg(message, 'Mean Template', 'Y','N', 'Y');
    
    if isempty(reply)
        reply = 'N';
    end
end

%%% show the mean template and its manual-segmented mask
% figure; imshow(MeanTp,[],'Border','tight'); hold on;
% contour(MeanTpMsk*2-1,[0 0],'r'); hold off;
% title('Mean template and its mask');

fprintf('Finally, generate the statistical template model.\n');

[simulated_tp] = ...
    Simulated_Shape_PCA_New(MeanTp,MeanTpMsk,MeanPatchMsk,tp_cluster,opt);

[simulated_tp_cluster_all] = Tp_RotateAndScale_New(simulated_tp);

pause (1);




