function [simulated_tp_cluster_all,MeanTp,MeanTpMsk] = PCA_Template_Generator9(ImgPatch_Cluster)
%%% this function is to produce the simulated templates based on the real
%%% image patches
%%% written by Cheng Chen (chengchen@cmu.edu)

%%% step 1: we choose the max height and width to select the size of 
%%% the standard template
tic;

PatchNum = size(ImgPatch_Cluster,2);
tp_cluster = cell(1,PatchNum);
maxH = 0;
maxW = 0;

for i_patch = 1:PatchNum
    one_patch = ImgPatch_Cluster{i_patch};
    PatchSz = size(one_patch);
    if PatchSz(1)>maxH
        maxH = PatchSz(1);
    end
    if PatchSz(2)>maxW
        maxW = PatchSz(2);
    end
end

%%% actually, we increase the size of template a little bit
offsetH = round(((maxH-1)/2)*1.5);
offsetW = round(((maxW-1)/2)*1.5);

%%% step 2: randomly choose one to build a standard template

special_idx = mod(ceil(100.*rand(1,1)),PatchNum)+1; % randomly produce idx

special_patch = ImgPatch_Cluster{special_idx};
[Angle, Center] = ImageMoment(special_patch);
PatchSz = size(special_patch);
[patchX,patchY] = meshgrid(1:PatchSz(2),1:PatchSz(1));
patchX = patchX-Center(1);
patchY = patchY-Center(2);
[tpX,tpY] = meshgrid(-offsetW:offsetW,-offsetH:offsetH);
ZI = interp2(patchX,patchY,special_patch,tpX,tpY);
[special_tp] = NaNFix(ZI); % the special_tp is the initial standard template


%%% step 3: first, we do a rigid-registration, move the center of mass at
%%% the center of the standard template, and rotate the orientation to be
%%% vertical, this could make the following registration to be accurate

for i_patch = 1:PatchNum
    i_patch
    one_patch = ImgPatch_Cluster{i_patch};
    [ImgTp] = ImgRigidAlignment(special_tp,one_patch);
    tp_cluster{i_patch} = ImgTp;
end

%%% temporary: select different amount of samples
randL = randperm(30);

N = 30;
tp_cluster_N = cell(1,N);
for i_tp = 1:N
    tp_cluster_N{1,i_tp} = tp_cluster{1,randL(i_tp)};
end

%%% step 4: calculate the mean image as the initial template
special_idx = 1;
InitTp = tp_cluster_N{special_idx};

[MeanTp] = MeanImgTemplate(tp_cluster_N,InitTp);



[MeanTpMsk] = ManualSeg_LevelSet(MeanTp);

%%% show the mean template and its manual-segmented mask
% figure; imshow(MeanTp,[],'Border','tight'); hold on;
% contour(MeanTpMsk*2-1,[0 0],'r'); hold off; 
% title('Mean template and its mask');
tic;
[simulated_tp] = Simulated_Shape_PCA(MeanTp,MeanTpMsk,tp_cluster_N);

[simulated_tp_cluster_all] = Tp_RotateAndScale(simulated_tp);
time2 = toc;



