function [simulated_tp_cluster_all,MeanTp,MeanTpMsk] = PCA_Template_Generator(ImgPatch_Cluster)
%%% this function is to produce the simulated templates based on the real
%%% image patches
%%% written by Cheng Chen (chengchen@cmu.edu)

%%% step 1: we choose the max height and width among sample patches selected
%%% to select the size of the standard template

PatchNum = size(ImgPatch_Cluster,2);
tp_cluster = cell(2,PatchNum);
maxH = 0;
maxW = 0;

for i_patch = 1:PatchNum   
    one_patch = ImgPatch_Cluster{i_patch};
    PatchSz = size(one_patch);
    if PatchSz(1)>maxH
        maxH = PatchSz(1);
    end
    if PatchSz(2)>maxW
        maxW = PatchSz(2);
    end
end

%%% actually, we increase the size of template a little bit
%%% and finalize the standard size of templates
offsetH = round(((maxH-1)/2)*1.5);
offsetW = round(((maxW-1)/2)*1.5);

%%% step 2: randomly choose one to build a standard template

special_idx = mod(ceil(100.*rand(1,1)),PatchNum)+1; % randomly produce idx

special_patch = ImgPatch_Cluster{special_idx};
[Angle, Center] = ImageMoment(special_patch);
PatchSz = size(special_patch);
[patchX,patchY] = meshgrid(1:PatchSz(2),1:PatchSz(1));
patchX = patchX-Center(1);
patchY = patchY-Center(2);
[tpX,tpY] = meshgrid(-offsetW:offsetW,-offsetH:offsetH);
ZI = interp2(patchX,patchY,special_patch,tpX,tpY);
[special_tp] = NaNFix(ZI); % the special_tp is the initial standard template
% special_tp_patch_msk = logical(~isnan(ZI)); % the mask of the patch

%%% step 3: first, we do a rigid-registration, move the center of mass at
%%% the center of the standard template, and rotate the orientation to be
%%% vertical, this could make the following registration to be accurate
fprintf('Rigid alignment first.\n');
for i_patch = 1:PatchNum   
    i_patch
    one_patch = ImgPatch_Cluster{i_patch};
    [ImgTp,ImgPatchMsk] = ImgRigidAlignment_New(special_tp,one_patch);
    tp_cluster{1,i_patch} = ImgTp;
    tp_cluster{2,i_patch} = ImgPatchMsk;
end

%%% step 4: calculate the mean image as the initial template
fprintf('Then, calculate the mean template.\n');
InitTp = tp_cluster{1,special_idx}.*tp_cluster{2,special_idx};
InitPatchMsk = tp_cluster{2,special_idx};

[MeanTp] = MeanImgTemplate_New(tp_cluster,InitTp,InitPatchMsk);

%%% step 5: segment the mean template via either manual or auto methods

% reply = 'N';
%
% while reply~='Y' && reply~='y'
%     [MeanTpMsk] = ManualSeg_LevelSet(MeanTp);
%
%     reply = input('Do you satisfy with current result? Y/N [Y]: ', 's');
%     if isempty(reply)
%         reply = 'N';
%     end
% end

reply = 'N';

while reply~='Y'
    [MeanTpMsk] = ManualSeg_LevelSet(MeanTp);
    
    message = sprintf('Do you satisfy with current result?');
    reply = questdlg(message, 'Mean Template', 'Y','N', 'Y');
    
    if isempty(reply)
        reply = 'N';
    end
end

% [MeanTpMsk] = AutoSeg_LevelSet(MeanTp);

%%% show the mean template and its manual-segmented mask
% figure; imshow(MeanTp,[],'Border','tight'); hold on;
% contour(MeanTpMsk*2-1,[0 0],'r'); hold off;
% title('Mean template and its mask');

fprintf('Finally, generate the statistical template model.\n');

[simulated_tp] = Simulated_Shape_PCA_New(MeanTp,MeanTpMsk,InitPatchMsk,tp_cluster);

[simulated_tp_cluster_all] = Tp_RotateAndScale(simulated_tp);

pause (1);




