function [label] = Overlap_Detector(shrink_vector,tp_cluster,SeedPtMap,AreaPtRow,AreaPtCol)
imgSz = size(SeedPtMap);
tp_msk_map = zeros(imgSz);
label = zeros(length(AreaPtRow),1);

for m_seed = 1:length(AreaPtRow)
    
    CurrentIdx = SeedPtMap(AreaPtRow(m_seed),AreaPtCol(m_seed));
    Tp_Msk = double(tp_cluster{2,CurrentIdx}); % get the mask
            
    templateSz = size(Tp_Msk);
    
    offset1 = double(templateSz(1)-1)/2;
    offset2 = double(templateSz(2)-1)/2;
            
    [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
    dX = dX-offset2-1;
    dY = dY-offset1-1;
        
    dX2 = dX*shrink_vector(m_seed);
    dY2 = dY*shrink_vector(m_seed);        
        
    Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
    Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);
            
    tp_msk_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
            
    tp_msk_map_tmp2 = padarray(zeros(imgSz),[offset1,offset2],'replicate','both');
    tp_msk_map_tmp2((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2));
            

     tp_msk_map_ext = tp_msk_map_ext+tp_msk_map_tmp2;
            

     tp_msk_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            
     tp_msk_map = tp_msk_map2;
                                    
end


tp_msk_map_overlap = tp_msk_map;
        
 for m_seed = 1:length(AreaPtRow)
            
     CurrentIdx = SeedPtMap(AreaPtRow(m_seed),AreaPtCol(m_seed));
            
     Tp_Msk = double(tp_cluster{2,CurrentIdx});
            
     templateSz = size(Tp_Msk);
    
     offset1 = double(templateSz(1)-1)/2;
     offset2 = double(templateSz(2)-1)/2;
            
     [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
     dX = dX-offset2-1;
     dY = dY-offset1-1;
        
     dX2 = dX*shrink_vector(m_seed);
     dY2 = dY*shrink_vector(m_seed);        
        
     Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
     Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);
                         
     tp_msk_map_tmp2 = padarray(zeros(imgSz),[offset1,offset2],'replicate','both');
     tp_msk_map_tmp2((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2));
           
     tp_msk_map_single = zeros(imgSz(1),imgSz(2));
     tp_msk_map_single(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_tmp2(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            
            
     overlap_detect = tp_msk_map_overlap.*tp_msk_map_single;
            
     if max(overlap_detect(:))>1
         label(m_seed) = 1;
     end
 end