function [ZI_Fixed] = NaNFix(ZI)
%%% this function is to fix the NaN problem in the matrix from
%%% interpolation, the idea is to choose the intensity from the nearest
%%% non-nan pixels
%%% written by Cheng Chen 

NaN_Map = isnan(ZI);

if sum(NaN_Map(:))==0
    ZI_Fixed = ZI;
else
    [D,L] = bwdist(~isnan(ZI));
    ZI2 = ZI.*(~isnan(ZI));

    [SeedPtRow,SeedPtCol] = find(NaN_Map);
    
    for i_pt = 1:length(SeedPtRow)
        j_height = SeedPtRow(i_pt);
        k_width = SeedPtCol(i_pt);
        LLL = L(j_height,k_width);
        LLL_Y = mod(LLL,size(ZI,1));
        
        if LLL_Y==0
            LLL_Y = size(ZI,1);
        end
        LLL_X = (LLL-LLL_Y)/size(ZI,1)+1;
        ZI2(j_height,k_width) = ...
            ZI(LLL_Y,LLL_X);        
    end
    
% for j_height=1:size(ZI,1)
%     for k_width=1:size(ZI,2)
%         if NaN_Map(j_height,k_width)==1
%             LLL = L(j_height,k_width);
%             LLL_Y = mod(LLL,size(ZI,1));
%             if LLL_Y==0
%                 LLL_Y = size(ZI,1);
%             end
%             LLL_X = (LLL-LLL_Y)/size(ZI,1)+1;
%             ZI2(j_height,k_width) = ...
%                 ZI(LLL_Y,LLL_X);
%         end
%     end
% end
    ZI_Fixed = ZI2;
end