function [MeanTp] = MeanImgTemplate_New(tp_cluster,InitTp,InitPatchMsk,opt)
%%% this function is to create a mean template which has the average shape
%%% and the average intensity of all tps when an initial template is given
%%% written by Cheng Chen (chengchen@cmu.edu)
[M,N,K] = size(InitTp);
TpSz = [M,N];
tpNum = length(tp_cluster);

error = 1000;
TH = 0.005;
iter_count = 0;

%%% note that in this program, we modify a little bit where we restrict 
%%% the number of iterations to 3 in order to save the computational time
max_iter = 5;

while error>=TH && iter_count<max_iter     
    AvedX = zeros(TpSz);
    AvedY = zeros(TpSz);
    
    for j_tp = 1:tpNum        
        target_img = tp_cluster{1,j_tp};
        target_patchmsk = tp_cluster{2,j_tp};
%         [Mkxy, dX, dY, current_ncc] = ...
%             nr_ncc3(target_img.*target_patchmsk, InitTp.*InitPatchMsk, opt);
        CommonMsk = InitPatchMsk(:,:,1);
        [Mkxy, dX, dY, current_ncc] = ...
            nr_ncc2(target_img, InitTp, CommonMsk, CommonMsk, opt);
        AvedX = AvedX+dX; 
        AvedY = AvedY+dY;
    end
    
    AvedX = AvedX/tpNum;
    AvedY = AvedY/tpNum;
    AveTp = zeros(M,N,K);
    
    for k_channel = 1:K
        xi = AvedX(:);
        yi = AvedY(:);
        InitTp_Single = zeros(M,N);
        InitTp_Single(1:M,1:N) = InitTp(1:M,1:N,k_channel);
        zi = InitTp_Single(:);
    
    %%% restrict the coordinate to prevent NaN problem
%     xi(xi<=1) = 1;
%     xi(xi>=TpSz(2)) = TpSz(2);
%     yi(yi<=1) = 1;
%     yi(yi>=TpSz(1)) = TpSz(1);
    
        F = TriScatteredInterp(xi,yi,zi);
        [XI,YI] = meshgrid(1:TpSz(2),1:TpSz(1));
        AveTpSingle = F(XI,YI);
        [AveTpSingle] = NaNFix(AveTpSingle);
        AveTp(1:M,1:N,k_channel) = AveTpSingle(1:M,1:N);
%     figure; imshow(AveTp,[]); impixelinfo; pause;
    end
    
    NewTp = zeros(M,N,K);
    
    for j_tp = 1:tpNum
        target_img = tp_cluster{1,j_tp};
        target_patchmsk = tp_cluster{2,j_tp};
        
        CommonMsk = InitPatchMsk(:,:,1);
        [Mkxy, dX, dY, current_ncc] = ...
            nr_ncc2(target_img, AveTp, CommonMsk, CommonMsk, opt);
%         [Mkxy, dX, dY, current_ncc] = ...
%             nr_ncc3(target_img.*target_patchmsk, AveTp.*InitPatchMsk, opt);
        
        for k_layer = 1:K
            target_img_aligned = interp2(target_img(:,:,k_layer), dX, dY);
            [target_img_aligned] = NaNFix(target_img_aligned);
            NewTp(:,:,k_layer) = NewTp(:,:,k_layer)+target_img_aligned;
        end
    end
    
    NewTp = NewTp/tpNum; % gray scale mean of transformed training images
    [NewTp] = NaNFix(NewTp);

%     figure; imshow(NewTp,[]); impixelinfo; pause;
    
    diff = abs(NewTp-InitTp);
    diff2 = (diff.*diff);
    error = sum(diff2(:))/(size(diff2,1)*size(diff2,2)); 
    error = error^0.5
    InitTp = NewTp; % update the initial tp
    
    %%% here, we restrict the number of iterations to 3
    %%% in order to save computational time
    iter_count = iter_count+1;
    iter_count
end

MeanTp = NewTp;