function [MeanTp] = MeanImgTemplate2(tp_cluster)
%%% this function is to create a mean template which has the average shape
%%% and the average intensity of all tps when an initial template is given
%%% written by Cheng Chen (chengchen@cmu.edu)
PatchNum = length(tp_cluster); % number of images. Note: these images should be the same size

%%% first, randomly choose one image as the initial template
special_idx = mod(ceil(100.*rand(1,1)),PatchNum)+1; % randomly produce idx
InitTp = tp_cluster{special_idx};

TpSz = size(InitTp);
tpNum = length(tp_cluster);

% opt.max_it = 100; %maximum number of iterations in one resolution
% opt.lambda = 50000;  % Step size of the velocity update
% opt.sigma = 2; % Size of Gaussian smoothing for images
% opt.sigma_p = 1; % Size of Gaussian for smoothing deformation field
% opt.multiRes = 2; %number of multiple resolutions (minus 1)

opt.max_it = 200; %maximum number of iterations in one resolution
opt.lambda = 50000;  % Step size of the velocity update
opt.sigma_p = 1.5; % Size of Gaussian for smoothing deformation field
opt.multiRes = 2; %number of multiple resolutions (minus 1)

error = 1000;
TH = 0.01;

while error>=TH     
    AvedX = zeros(TpSz);
    AvedY = zeros(TpSz);
    
    for j_tp = 1:tpNum
        target_img = tp_cluster{j_tp};
        [Mkxy, dX, dY] = register_ncc_v3(target_img, InitTp, opt);
        AvedX = AvedX+dX; 
        AvedY = AvedY+dY;
    end
    
    AvedX = AvedX/tpNum;
    AvedY = AvedY/tpNum;
    
    xi = AvedX(:);
    yi = AvedY(:);
    zi = InitTp(:);
    
    %%% restrict the coordinate to prevent NaN problem
%     xi(xi<=1) = 1;
%     xi(xi>=TpSz(2)) = TpSz(2);
%     yi(yi<=1) = 1;
%     yi(yi>=TpSz(1)) = TpSz(1);
    
    F = TriScatteredInterp(xi,yi,zi);
    [XI,YI] = meshgrid(1:TpSz(2),1:TpSz(1));
    AveTp = F(XI,YI);
    [AveTp] = NaNFix(AveTp);
%     figure; imshow(AveTp,[]); impixelinfo; pause;
    
    NewTp = zeros(TpSz);
    for j_tp = 1:tpNum
        target_img = tp_cluster{j_tp};
        [Mkxy, dX, dY] = register_ncc_v3(target_img, AveTp, opt);
        target_img_aligned = interp2(target_img, dX, dY);
        [target_img_aligned] = NaNFix(target_img_aligned);
        NewTp = NewTp+target_img_aligned;
    end
    
    NewTp = NewTp/tpNum; % gray scale mean of transformed training images
    [NewTp] = NaNFix(NewTp);

%     figure; imshow(NewTp,[]); impixelinfo; pause;
    
    diff = abs(NewTp-InitTp);
    diff2 = (diff.*diff);
    error = sum(diff2(:))/(size(diff2,1)*size(diff2,2)); 
    error = error^0.5;
    InitTp = NewTp;
    
    error
end

MeanTp = NewTp;