function [ImgPatch_Cluster,ShowMask] = Manual_Select_Patches(OrigImg)
%%% this function is to let users crop any image patches
fprintf('Start to crop the image patches from the whole image.\n');

imgSz = size(OrigImg);
PatchCount = 0;
ImgPatch_Cluster = cell(1,1);
FLAG = 1;
ShowMask = uint8(mat2gray(OrigImg)*255);

global KEY_IS_PRESSED
KEY_IS_PRESSED = 0;

figure;
imshow(OrigImg,'Border','tight'); 

fprintf('If you want to stop selecting on the current image.\n');
fprintf('Press "Enter" button, then drag any size rectangle to finish.\n');


while KEY_IS_PRESSED == 0
    set(gcf, 'KeyPressFcn', @myKeyPressFcn);
    
    if KEY_IS_PRESSED==1
        break;
    end
    
    H = imrect;
    
    if KEY_IS_PRESSED==1
        fprintf('Finish selecting on the current image.\n Drag any size rectangle to finish.\n');
        break;
    else
    position = wait(H);
    setColor(H,[1 0 0]);
    
    xmin = round(position(1));
    ymin = round(position(2));
    width = position(3); 
    height = position(4);
        
    xmax = xmin+width-1;
    ymax = ymin+height-1;
    
    if xmin<=0
        xmin = 1;
    end
    if ymin<=0
        ymin = 1;
    end
    if xmax>=imgSz(2)
        xmax = imgSz(2)-1;
    end
    if ymax>=imgSz(1)
        ymax = imgSz(1)-1;
    end
    
    new_width = xmax-xmin+1;
    new_height = ymax-ymin+1;
    
    if mod(new_width,2)==0
        new_width = new_width+1;
    end
    if mod(new_height,2)==0
        new_height = new_height+1;
    end
    
    ImgPatch = zeros(new_height,new_width);
    ImgPatch(1:new_height,1:new_width) = ...
        OrigImg(ymin:ymin+new_height-1,xmin:xmin+new_width-1);
    
    BinaryMask = zeros(imgSz(1),imgSz(2));
    BinaryMask(ymin:ymin+new_height-1,xmin:xmin+new_width-1) = 1;
    BinaryContour = bwmorph(BinaryMask,'remove');
    BinaryContour = imdilate(BinaryContour,ones(5));
    
    ShowMask(BinaryContour) = 255;
%     contour(BinaryMask*2-1,[0 0],'r');
    
%     api = iptgetapi(H);
%     position = api.getPosition();
    
    PatchCount = PatchCount+1;
    ImgPatch_Cluster{1,PatchCount} = ImgPatch;
    end
end
hold off;
close;

function myKeyPressFcn(hObject, event)
global KEY_IS_PRESSED
if strcmp(event.Key,'return')
    KEY_IS_PRESSED = 1;
end