function [ImgTp,ImgPatchMsk] = ImgRigidAlignment_New(TP,ImgPatch)
%%% this is just a simple version of image rigid registration
%%% written by Cheng Chen (chengchen@cmu.edu)
[M,N,K] = size(TP); % get the size of template
TpSz = [M,N]; %size(TP);
ImgTp = zeros(TpSz);
offsetH = (TpSz(1)-1)/2;
offsetW = (TpSz(2)-1)/2;

PatchSz = size(ImgPatch);
[Angle, Center] = ImageMoment(ImgPatch);
BestMatch = -10;  

for i_rotate = -90:3:90 % search every 3 degrees
    rotate_angle = i_rotate*pi/180;
    
    [patchX,patchY] = meshgrid(1:PatchSz(2),1:PatchSz(1));
    patchX = patchX-Center(1);
    patchY = patchY-Center(2);
    
    [tpX,tpY] = meshgrid(-offsetW:offsetW,-offsetH:offsetH);
    
    tpX2 = tpX.*cos(rotate_angle)+tpY.*sin(rotate_angle);
    tpY2 = -tpX.*sin(rotate_angle)+tpY.*cos(rotate_angle);
    
    ZI3 = zeros(M,N,K);
    
    for j_channel = 1:K        
        ZI = interp2(patchX,patchY,ImgPatch(:,:,j_channel),tpX2,tpY2);
        [ZI2] = NaNFix(ZI);
        ZI3(1:M,1:N,j_channel) = ZI2(1:M,1:N);
    end
   
    L_Sft = TP.*ZI3;
    SfT = sum(L_Sft(:));
    
    L_s = TP.^2;
    s_norm_sqrd = sum(L_s(:));
    
    L_t = ZI3.^2;
    t_norm_sqrd = sum(L_t(:));
    
    current_ncc = (SfT.^2)/(s_norm_sqrd*t_norm_sqrd);
       
    if current_ncc>BestMatch
        BestMatch = current_ncc;
        ImgTp = ZI3;
        
        ImgPatchMsk = zeros(M,N,K);
        
        for k_channel = 1:K
            ZI_nanmap = logical(~isnan(ZI));
            ImgPatchMsk(:,:,k_channel) = ZI_nanmap(:,:);
        end
        
        Angle = i_rotate;
    end   
end