function [ImgTp] = ImgRigidAlignment(TP,ImgPatch)
%%% this is just a simple version of image rigid registration
%%% written by Cheng Chen (chengchen@cmu.edu)

TpSz = size(TP);
ImgTp = zeros(TpSz);
offsetH = (TpSz(1)-1)/2;
offsetW = (TpSz(2)-1)/2;

PatchSz = size(ImgPatch);
[Angle, Center] = ImageMoment(ImgPatch);
BestMatch = -10;  

for i_rotate = -90:3:90 % search every 3 degrees
    rotate_angle = i_rotate*pi/180;
    
    [patchX,patchY] = meshgrid(1:PatchSz(2),1:PatchSz(1));
    patchX = patchX-Center(1);
    patchY = patchY-Center(2);
    
    [tpX,tpY] = meshgrid(-offsetW:offsetW,-offsetH:offsetH);
    
    tpX2 = tpX.*cos(rotate_angle)+tpY.*sin(rotate_angle);
    tpY2 = -tpX.*sin(rotate_angle)+tpY.*cos(rotate_angle);
    
    ZI = interp2(patchX,patchY,ImgPatch,tpX2,tpY2);

%     TF = double(~isnan(ZI));
%     [D,L] = bwdist(TF);
%     ZI2 = zeros(size(ZI));
%     
%     for j_height=1:size(ZI,1)
%         for k_width=1:size(ZI,2)
%             LLL = L(j_height,k_width);
%             LLL_Y = mod(LLL,size(ZI,1));
%             if LLL_Y==0
%                 LLL_Y = size(ZI,1);
%             end
%             LLL_X = (LLL-LLL_Y)/size(ZI,1)+1;
%             ZI2(j_height,k_width) = ...
%                 ZI(LLL_Y,LLL_X);
%         end
%     end

    [ZI2] = NaNFix(ZI);
    
    SfT = sum(sum(TP.*ZI2));
    s_norm_sqrd = sum(sum(TP.^2));
    t_norm_sqrd = sum(sum(ZI2.^2));
    current_ncc = (SfT.^2)/(s_norm_sqrd*t_norm_sqrd);
       
    if current_ncc>BestMatch
        BestMatch = current_ncc;
        ImgTp = ZI2;
        Angle = i_rotate;
    end   
end