function [Angle, Center] = ImageMoment(Img)
%%% the function ImageMoment implements second moment algorithm
%%% the objective is to estimate the rotation angle
%%% written by Cheng Chen (chengchen@cmu.edu)

ImgSz = size(Img);

%%% note that if there are three channels, we convert it to gray-scale
if size(ImgSz, 2)==3
    if ImgSz(3)==3
        Img = rgb2gray(Img);
    end
end

Img = mat2gray(Img);
ImgSz = size(Img); 

[ImgX, ImgY] = meshgrid(1:ImgSz(2), 1:ImgSz(1));

m10 = sum(sum(ImgX.*Img));
m01 = sum(sum(ImgY.*Img));
m00 = sum(sum(Img));

CenterX = double(m10/m00);
CenterY = double(m01/m00);

Center = [CenterX,CenterY];

% figure; imshow(Img,[]); hold on;
% plot(CenterX,CenterY,'rx'); hold off;

ImgX = ImgX-CenterX;
ImgY = -(ImgY-CenterY);

Center = round(Center);

u00 = sum(sum(Img));
u11 = sum(sum(ImgX.*ImgY.*Img));
u20 = sum(sum(ImgX.*ImgX.*Img));
u02 = sum(sum(ImgY.*ImgY.*Img));

uxy = u11/u00;
uyy = u02/u00+1/12;
uxx = u20/u00+1/12;

if (uyy > uxx)
    num = uyy - uxx + sqrt((uyy - uxx)^2 + 4*uxy^2);
    den = 2*uxy;
else
    num = 2*uxy;
    den = uxx - uyy + sqrt((uxx - uyy)^2 + 4*uxy^2);
end


% Angle = atan(2*u11_prime/(u20_prime-u02_prime));
% Angle = 0.5*Angle*180/pi;

if (num==0) && (den==0)
    Angle = 0;
else
    Angle = (180/pi)*atan(num/den);
end

%             % Assign X and Y variables so that we're measuring orientation
%             % counterclockwise from the horizontal axis.
% 
%             xbar = stats(k).Centroid(1);
%             ybar = stats(k).Centroid(2);
% 
%             x = list(:,1) - xbar;
%             y = -(list(:,2) - ybar); 
%             % This is negative for the
%             % orientation calculation (measured in the
%             % counter-clockwise direction).
% 
%             N = length(x);
% 
%             % Calculate normalized second central moments for the region. 1/12 is
%             % the normalized second central moment of a pixel with unit length.
%             uxx = sum(x.^2)/N + 1/12;
%             uyy = sum(y.^2)/N + 1/12;
%             uxy = sum(x.*y)/N;
% 
%             
% 
%             % Calculate orientation.
%             if (uyy > uxx)
%                 num = uyy - uxx + sqrt((uyy - uxx)^2 + 4*uxy^2);
%                 den = 2*uxy;
%             else
%                 num = 2*uxy;
%                 den = uxx - uyy + sqrt((uxx - uyy)^2 + 4*uxy^2);
%             end
%             if (num == 0) && (den == 0)
%                 stats(k).Orientation = 0;
%             else
%                 stats(k).Orientation = (180/pi) * atan(num/den);
%             end
%         end