function [DeformedTp,DeformedMsk] = ...
    GSM_PCA_New(lambda, modes, HxyBar, MeanTp, MeanTpMsk, MeanPatchMsk, princo, opt)
% This function shows the results of the generated shape model of 
% lembda is the coef of the specific mode
% modes is the input principle modes, each column represent one mode
% HxyBar is the mean of the vector of the deformation transformation
% meanshp is the input meanshape of the data set
% princo represent which mode is to represent
% % eg. MODEL(1:sizeY, (3*sizeX+1):4*sizeX)=GSM_pca(0, Modes, HxyBar,
% template, 1);

[N, M, K] = size(MeanTp);
[xhbar, yhbar] = vectorSeperate(HxyBar, N, M); % seperate the deformations X, Y

[xh_m1p, yh_m1p] = vectorSeperate(modes(:,princo), N, M);

xh_m1_fr = xhbar+lambda*xh_m1p;
yh_m1_fr = yhbar+lambda*yh_m1p;

% xh_m1_fr(find(xh_m1_fr>=M)) = M;
% xh_m1_fr(find(xh_m1_fr<=1)) = 1;
% yh_m1_fr(find(yh_m1_fr>=N)) = N;
% yh_m1_fr(find(yh_m1_fr<=1)) = 1;


%  Directly use the griddata function will elicit the smooth images, but
%  sometime will have error
% img = griddata(double(xh_m1_fr),double(yh_m1_fr),double(meanshp),X,Y);

% F_Img = TriScatteredInterp(double(xh_m1_fr(:)),double(yh_m1_fr(:)),double(MeanTp(:)));
% [qx,qy] = meshgrid(1:M,1:N);
% Img = F_Img(qx,qy);

RoughDeformedTp = zeros(N,M,K);

for k_layer = 1:K
    MeanTpSingle = zeros(N,M);
    MeanTpSingle(1:N,1:M) = MeanTp(1:N,1:M,k_layer);
    F_Img = TriScatteredInterp(double(xh_m1_fr(:)),double(yh_m1_fr(:)),double(MeanTpSingle(:)));
    [qx,qy] = meshgrid(1:M,1:N);
    RoughDeformedTpSingle = F_Img(qx,qy);
    [RoughDeformedTpSingle] = NaNFix(RoughDeformedTpSingle);
    RoughDeformedTp(1:N,1:M,k_layer) = RoughDeformedTpSingle(1:N,1:M);
end

MeanPatchMskSingle = zeros(N,M);
MeanPatchMskSingle(1:N,1:M) = MeanPatchMsk(1:N,1:M,1);
F_Msk = TriScatteredInterp(double(xh_m1_fr(:)),double(yh_m1_fr(:)),double(MeanPatchMskSingle(:)),'nearest');
[qx,qy] = meshgrid(1:M,1:N);
RoughDeformedPatchMsk = F_Msk(qx,qy);
[RoughDeformedPatchMsk] = NaNFix(RoughDeformedPatchMsk);

% figure;
% imagesc(RoughDeformedTp); colormap gray; axis off; axis equal; hold on;
% plot(xh_m1_fr(:,1:10:M),yh_m1_fr(:,1:10:M),'g');
% plot(xh_m1_fr(1:10:N,:)',yh_m1_fr(1:10:N,:)','g');
% hold off;
% title('The rough deformed template and its deformed grid');

% [Mkxy, inv_dX, inv_dY, current_ncc] = ...
%             nr_ncc3(MeanTp.*MeanPatchMsk, RoughDeformedTp.*MeanPatchMsk, opt);
        
CommonMsk = RoughDeformedPatchMsk;
[Mkxy, inv_dX, inv_dY, current_ncc] = ...
            nr_ncc2(MeanTp, RoughDeformedTp, CommonMsk, CommonMsk, opt);
        

% inv_dX(find(inv_dX>=M)) = M;
% inv_dX(find(inv_dX<=1)) = 1;
% inv_dY(find(inv_dY>=N)) = N;
% inv_dY(find(inv_dY<=1)) = 1;

DeformedTp = zeros(N,M,K);

for k_layer = 1:K
    MeanTpSingle = zeros(N,M);
    MeanTpSingle(1:N,1:M) = MeanTp(1:N,1:M,k_layer);
    DeformedTpSingle = interp2(MeanTpSingle, inv_dX, inv_dY); 
    [DeformedTpSingle] = NaNFix(DeformedTpSingle);
    DeformedTp(1:N,1:M,k_layer) = DeformedTpSingle(1:N,1:M);
end


% figure;
% imagesc(DeformedTp); colormap gray; axis off; axis equal; hold on;
% plot(inv_dX(:,1:10:M),inv_dY(:,1:10:M),'g');
% plot(inv_dX(1:10:N,:)',inv_dY(1:10:N,:)','g');
% hold off;
% title('The final deformed template and its deformed grid');


DeformedMsk = interp2(MeanTpMsk, inv_dX, inv_dY, 'nearest');
[DeformedMsk] = NaNFix(DeformedMsk);
DeformedMsk = double(imfill(DeformedMsk,'holes'));
