function [DeformedTp,DeformedMsk] = GSM_PCA(lambda, modes, HxyBar, MeanTp, MeanTpMsk, princo, opt)
% This function shows the results of the generated shape model of 
% lembda is the coef of the specific mode
% modes is the input principle modes, each column represent one mode
% HxyBar is the mean of the vector of the deformation transformation
% meanshp is the input meanshape of the data set
% princo represent which mode is to represent
% % eg. MODEL(1:sizeY, (3*sizeX+1):4*sizeX)=GSM_pca(0, Modes, HxyBar,
% template, 1);

[N, M] = size(MeanTp);
[xhbar, yhbar] = vectorSeperate(HxyBar, N, M); % seperate the deformations X, Y

[xh_m1p, yh_m1p] = vectorSeperate(modes(:,princo), N, M);

xh_m1_fr = xhbar+lambda*xh_m1p;
yh_m1_fr = yhbar+lambda*yh_m1p;

% xh_m1_fr(find(xh_m1_fr>=M)) = M;
% xh_m1_fr(find(xh_m1_fr<=1)) = 1;
% yh_m1_fr(find(yh_m1_fr>=N)) = N;
% yh_m1_fr(find(yh_m1_fr<=1)) = 1;


%  Directly use the griddata function will elicit the smooth images, but
%  sometime will have error
% img = griddata(double(xh_m1_fr),double(yh_m1_fr),double(meanshp),X,Y);

%%% I have to say: this implementation is not correct
% Img = interp2(double(MeanTp),double(xh_m1_fr),double(yh_m1_fr));

% F_Img = TriScatteredInterp(double(xh_m1_fr(:)),double(yh_m1_fr(:)),double(MeanTp(:)));
% [qx,qy] = meshgrid(1:M,1:N);
% Img = F_Img(qx,qy);

F_Img = TriScatteredInterp(double(xh_m1_fr(:)),double(yh_m1_fr(:)),double(MeanTp(:)));
[qx,qy] = meshgrid(1:M,1:N);
RoughDeformedTp = F_Img(qx,qy);
[RoughDeformedTp] = NaNFix(RoughDeformedTp);

% figure;
% imagesc(RoughDeformedTp); colormap gray; axis off; axis equal; hold on;
% plot(xh_m1_fr(:,1:10:M),yh_m1_fr(:,1:10:M),'g');
% plot(xh_m1_fr(1:10:N,:)',yh_m1_fr(1:10:N,:)','g');
% hold off;
% title('The rough deformed template and its deformed grid');

STATS = regionprops(MeanTpMsk, 'BoundingBox');
W_MeanTp = zeros(N,M);
qq = STATS.BoundingBox;

W_MeanTp(round(qq(2))-20:round(qq(2)+qq(4))+20,round(qq(1))-20:round(qq(1)+qq(3))+20) = 1;

[Mkxy, inv_dX, inv_dY, current_ncc] = ...
            nr_ncc2(MeanTp, RoughDeformedTp, W_MeanTp, W_MeanTp, opt);
% [Mkxy, inv_dX, inv_dY] = register_ncc_v3(MeanTp, RoughDeformedTp, opt);

% inv_dX(find(inv_dX>=M)) = M;
% inv_dX(find(inv_dX<=1)) = 1;
% inv_dY(find(inv_dY>=N)) = N;
% inv_dY(find(inv_dY<=1)) = 1;

DeformedTp = interp2(MeanTp, inv_dX, inv_dY); 
[DeformedTp] = NaNFix(DeformedTp);

% figure;
% imagesc(DeformedTp); colormap gray; axis off; axis equal; hold on;
% plot(inv_dX(:,1:10:M),inv_dY(:,1:10:M),'g');
% plot(inv_dX(1:10:N,:)',inv_dY(1:10:N,:)','g');
% hold off;
% title('The final deformed template and its deformed grid');


DeformedMsk = interp2(MeanTpMsk, inv_dX, inv_dY, 'nearest');
[DeformedMsk] = NaNFix(DeformedMsk);
DeformedMsk = double(imfill(DeformedMsk,'holes'));
