function Center = FindCenter(Img)
%%% the function implements second moment algorithm
%%% the objective is to estimate the rotation angle
%%% note that this function is just for rgb channel image use
%%% written by Cheng Chen (chengchen@cmu.edu)

%%% if there are three channels, then we convert it to gray-scale
% if length(ImgSz)==3
%     Img = double(Img);
%     Img = uint8(mat2gray(Img)*255);
%     Img = double(rgb2gray(Img));
% end
% 
% Img = mat2gray(Img);
ImgSz = size(Img); 

[ImgX,ImgY,ImgZ] = meshgrid(1:ImgSz(2),1:ImgSz(1),1:3);

m10 = sum(sum(sum(ImgX.*Img)));
m01 = sum(sum(sum(ImgY.*Img)));
m00 = sum(sum(sum(Img)));

CenterX = double(m10/m00);
CenterY = double(m01/m00);

Center = [CenterX,CenterY];

Center = round(Center);
