function [Final_Result] = FinalAccurateSeg_New(Data_Cluster)
%%% this function is to use non-rigid registration to do the final
%%% segmentation for each image patch and generate as the final result
%%% written by Cheng Chen (chengchen@cmu.edu);

opt.sigma = 15; %std of basis function for modeling deformations
opt.sigma_i = 2; %std of basis functions for computing image derivatives
opt.max_pix_displacement = 2; %maximum pixel displacement in one gradient descent iteration
opt.n_stepsizes = 5; %number of step sizes to try within one gradient descent iteration
opt.max_iterations = 500; %maximum number of gradient descent iterations to use
opt.tolerance = 10^(-5); %smallest acceptable improvement in each iteration

PatchNum = size(Data_Cluster,2);
Final_Result = cell(1,3);
ResultCount = 0;

for i_patch = 1:PatchNum
    fprintf('Refine the %dth patch.\n',i_patch);
    CellNum = Data_Cluster{1,i_patch};
    
    if CellNum==1 % for single nucleus case       
        Raw_Img = Data_Cluster{2,i_patch};
        Tp_Img = Data_Cluster{3,i_patch};
        Tp_Msk = Data_Cluster{4,i_patch};
        Tp_Patch_Msk = Data_Cluster{6,i_patch};
        PostInfo = Data_Cluster{5,i_patch};
                
        %%% segment by non-rigid registration
        Tp_Patch_Msk = imdilate(Tp_Patch_Msk,ones(5,5));
        
        CommonMsk = Tp_Patch_Msk(:,:,1);
        [Mkxy, dX, dY, current_ncc] = ...
            nr_ncc2(Tp_Img, Raw_Img, CommonMsk, CommonMsk, opt);
        
%         [Mkxy, dX, dY, current_ncc] = ...
%             nr_ncc3(Tp_Img.*Tp_Patch_Msk, Raw_Img.*Tp_Patch_Msk, opt);

        [DeformedMsk] = interp2(Tp_Msk,dX,dY);
        [DeformedMsk] = NaNFix(DeformedMsk); 
        DeformedMsk = imfill(DeformedMsk,'holes');
        DeformedMsk  = bwareaopen(DeformedMsk,300);
         
        %%% store the final result for each single nucleus patch
        ResultCount = ResultCount+1;
        Final_Result{ResultCount,1} = DeformedMsk;
        Final_Result{ResultCount,2} = PostInfo;
        Final_Result{ResultCount,3} = CellNum;

    else    % for multiple touching nuclei case
        Raw_Img = Data_Cluster{2,i_patch};
        Tp_Img = Data_Cluster{3,i_patch};
        Tp_Patch_Msk = Data_Cluster{4,i_patch};
        Tp_Msk = double(full(Data_Cluster{5,i_patch}));
        PostInfo = Data_Cluster{7,i_patch};
       
        %%% segment by non-rigid registration
        Tp_Patch_Msk = imdilate(Tp_Patch_Msk,ones(5,5));
        
        CommonMsk = Tp_Patch_Msk(:,:,1);
        [Mkxy, dX, dY, current_ncc] = ...
            nr_ncc2(Tp_Img, Raw_Img, CommonMsk, CommonMsk, opt);
%         [Mkxy, dX, dY, current_ncc] = ...
%             nr_ncc3(Tp_Img.*Tp_Patch_Msk2, Raw_Img.*Tp_Patch_Msk2, opt);

        for i_cell = 1:CellNum          
            SingleMsk = double(full(Data_Cluster{6,i_patch}{i_cell}));

            [DeformedMsk] = interp2(SingleMsk,dX,dY);
            [DeformedMsk] = NaNFix(DeformedMsk); 
            DeformedMsk = imfill(DeformedMsk,'holes');
            DeformedMsk  = bwareaopen(DeformedMsk,300); 

            ResultCount = ResultCount+1;
            Final_Result{ResultCount,1} = DeformedMsk;
            Final_Result{ResultCount,2} = PostInfo;
            Final_Result{ResultCount,3} = CellNum;
        end
    end
end


