function [Final_Result] = FinalAccurateSeg(Data_Cluster)
%%% this function is to use non-rigid registration to do the final
%%% segmentation for each image patch and generate as the final result
%%% written by Cheng Chen (chengchen@cmu.edu);

PatchNum = size(Data_Cluster,2);
Final_Result = cell(1,3);
ResultCount = 0;

for i_patch = 1:PatchNum
    fprintf('Refine the %dth patch.\n',i_patch);
    CellNum = Data_Cluster{1,i_patch};
    
    if CellNum==1 % for single nucleus case
        Raw_Img = Data_Cluster{2,i_patch};
        Tp_Img = Data_Cluster{3,i_patch};
        Tp_Msk = Data_Cluster{4,i_patch};
        PostInfo = Data_Cluster{5,i_patch};
        TpSz = size(Tp_Img);
        
        %%% segment by non-rigid registration
%         opt.max_it = 400; %maximum number of iterations in one resolution
%         opt.lambda = 50000;  % Step size of the velocity update
%         opt.sigma_p = 0.5; % Size of Gaussian for smoothing deformation field
%         opt.multiRes = 3; %number of multiple resolutions (minus 1)
        
        %%% synthetic data
%         opt.max_it = 200; %maximum number of iterations in one resolution
%         opt.lambda = 50000;  % Step size of the velocity update
%         opt.sigma_p = 2.5; % Size of Gaussian for smoothing deformation field
%         opt.multiRes = 1; 

        %%% histological data
        %% Latest datas parameters
%         opt.max_it = 50; %maximum number of iterations in one resolution
%         opt.lambda = 150000;  % Step size of the velocity update
%         opt.sigma_p = 1.0; % Size of Gaussian for smoothing deformation field
%         opt.multiRes = 2; %number of multiple resolutions (minus 1)
%         [Mkxy, dX, dY, current_ncc] = register_ncc_v3(Raw_Img, Tp_Img, opt);

        opt.max_it = 500; %maximum number of iterations in one resolution
        opt.lambda = 350000;  % Step size of the velocity update
        opt.sigma_p = 0.9; % Size of Gaussian for smoothing deformation field
        opt.multiRes = 2; 
        
        [Mkxy, dX, dY, current_ncc] = register_ncc_v3(Tp_Img, Raw_Img, opt);

        %%% discard if the matching value is too low
%         if current_ncc<0.5
%             disp('Incorrect nuclei. Jump over...');
%             continue;
%         end
    
        %%% interpolation 
%         xi = dX(:);
%         yi = dY(:);
%         zi = Tp_Msk(:);
%         F = TriScatteredInterp(xi,yi,zi);
%         [XI,YI] = meshgrid(1:TpSz(2),1:TpSz(1));
%         DeformedMsk = F(XI,YI);
%         [DeformedMsk] = NaNFix(DeformedMsk);

        [DeformedMsk] = interp2(Tp_Msk,dX,dY);
        [DeformedMsk] = NaNFix(DeformedMsk); 
        DeformedMsk = imfill(DeformedMsk,'holes');
        DeformedMsk  = bwareaopen(DeformedMsk,300);
         
        %%% store the final result for each single nucleus patch
        ResultCount = ResultCount+1;
        Final_Result{ResultCount,1} = DeformedMsk;
        Final_Result{ResultCount,2} = PostInfo;
        Final_Result{ResultCount,3} = CellNum;
%         Final_Result{ResultCount,4} = Raw_Img.*DeformedMsk;
        
        %%% final seg result for single nucleus
%         figure; imshow(Raw_Img,[]); 
%         hold on;
%         contour(DeformedMsk*2-1,[0,0],'r');
%         contour(Tp_Msk*2-1,[0,0],'b');
%         hold off;    

    
    else    % for multiple touching nuclei case
        Raw_Img = Data_Cluster{2,i_patch};
        Tp_Img_Total = Data_Cluster{3,i_patch};
%         Tp_Msk_Total = Data_Cluster{4,i_patch};
        PostInfo = Data_Cluster{7,i_patch};
       
        %%% segment by non-rigid registration
%         opt.max_it = 200; %maximum number of iterations in one resolution
%         opt.lambda = 50000;  % Step size of the velocity update
%         opt.sigma_p = 2.5; % Size of Gaussian for smoothing deformation field
%         opt.multiRes = 1; 
        
%         opt.max_it = 400; %maximum number of iterations in one resolution
%         opt.lambda = 50000;  % Step size of the velocity update
%         opt.sigma_p = 0.5; % Size of Gaussian for smoothing deformation field
%         opt.multiRes = 3; %number of multiple resolutions (minus 1)

        %%% histological data
        %% Latest datas parameters
%         opt.max_it = 50; %maximum number of iterations in one resolution
%         opt.lambda = 150000;  % Step size of the velocity update
%         opt.sigma_p = 1.0; % Size of Gaussian for smoothing deformation field
%         opt.multiRes = 2;
%         
        opt.max_it = 500; %maximum number of iterations in one resolution
        opt.lambda = 350000;  % Step size of the velocity update
        opt.sigma_p = 0.9; % Size of Gaussian for smoothing deformation field
        opt.multiRes = 2; 
    
        %%% discard if the matching value is too low
%         if current_ncc<0.5
%             disp('Incorrect nuclei. Jump over...');
%             continue;
%         end
        
        TpSz = size(Tp_Img_Total);     
        [Mkxy, dX, dY, current_ncc] = register_ncc_v3(Tp_Img_Total, Raw_Img, opt);
        
%         figure; imshow(Raw_Img,[]);
%         hold on;
        for i_cell = 1:CellNum
%             SingleTp = double(Data_Cluster{5,i_patch}{i_cell});
%             [Mkxy, dX, dY, current_ncc] = register_ncc_v3(Raw_Img, SingleTp, opt);
%             [Mkxy, dX, dY, current_ncc] = register_ncc_v3(SingleTp, Raw_Img, opt);
            
%             if current_ncc<0.5
%                 disp('Incorrect nuclei. Jump over...');
%                 continue;
%             end

            
            SingleMsk = double(Data_Cluster{6,i_patch}{i_cell});
            
%             TpSz = size(SingleMsk);
%             xi = dX(:);
%             yi = dY(:);
%             zi = SingleMsk(:);
%             F = TriScatteredInterp(xi,yi,zi);
%             [XI,YI] = meshgrid(1:TpSz(2),1:TpSz(1));
%             DeformedMsk = F(XI,YI);
%             [DeformedMsk] = NaNFix(DeformedMsk); 

            [DeformedMsk] = interp2(SingleMsk,dX,dY);
            [DeformedMsk] = NaNFix(DeformedMsk); 
            DeformedMsk = imfill(DeformedMsk,'holes');
            DeformedMsk  = bwareaopen(DeformedMsk,300); % we add a little bit morphological processing here

%             contour(DeformedMsk*2-1,[0,0],'r');
                   
            ResultCount = ResultCount+1;
            Final_Result{ResultCount,1} = DeformedMsk;
            Final_Result{ResultCount,2} = PostInfo;
            Final_Result{ResultCount,3} = CellNum;
        end
%         contour(Tp_Msk_Total*2-1,[0,0],'b');
%         hold off;    
%         
%         pause;
    end
end


