function [SeedPtMapNew,Data_Cluster] = Detected_ImgPatch_Generator_Whole(OrigImg,SeedPtMap,tp_cluster)
%%% this function is to create each cropped image patch with the masks
%%% written by Cheng Chen (chengchen@cmu.edu)

Data_Cluster = cell(4,1);
[M,N,K] = size(OrigImg);
% ChannelNum = K;
imgSz = [M,N];
SeedCount = 0;

AreaMap = ones(imgSz(1),imgSz(2));
BinaryAreaMap = double(AreaMap>0);

for j_area = 1:1
    fprintf('Start to extract the %dth patch to refine result.\n',j_area);
    SingleArea = double(BinaryAreaMap==j_area);
    SeedsContained = SingleArea.*SeedPtMap;
    [AreaPtRow,AreaPtCol] = find(SeedsContained);
    
    %%% first, we detect which region gets overlapped 
        
    flag = 0;
        
    shrink_vector = ones(length(AreaPtRow),1)*1.1;
        
    while flag==1
        [check_label] = Overlap_Detector(shrink_vector,tp_cluster,SeedPtMap,AreaPtRow,AreaPtCol);
        
        if max(check_label(:))==0
            flag = 0;
        end
        
        shrink_vector = shrink_vector+0.1*check_label;
    end
        
    single_tp_map = cell(2,length(AreaPtRow));
        
    %%% to store all the templates on a single image
    tp_img_map = zeros(imgSz);
    tp_msk_map = zeros(imgSz); 
            
    for m_seed = 1:length(AreaPtRow)
        m_seed
        CurrentIdx = SeedPtMap(AreaPtRow(m_seed),AreaPtCol(m_seed));
        Tp_Img = full(tp_cluster{1,CurrentIdx});
        Tp_Msk = double(tp_cluster{2,CurrentIdx});
            
        templateSz = size(Tp_Img);
    
        offset1 = double(templateSz(1)-1)/2;
        offset2 = double(templateSz(2)-1)/2;
            
        [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
        dX = dX-offset2-1;
        dY = dY-offset1-1;
        
        dX2 = dX*shrink_vector(m_seed);
        dY2 = dY*shrink_vector(m_seed);       
        
        Tp_Img_Patch = interp2(dX,dY,Tp_Img,dX2,dY2);
        Tp_Img_Patch = NaNFix(Tp_Img_Patch);
        
        Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
        Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);
                        
        tp_img_map_ext = padarray(tp_img_map,[offset1,offset2],'replicate','both');
        tp_msk_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
        tp_label_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
            
        %%% new coming template image and mask
        tp_msk_map_tmp = tp_msk_map_ext;
        tp_msk_map_tmp((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2)); 
            
        tp_msk_map_tmp2 = padarray(zeros(imgSz),[offset1,offset2],'replicate','both');
        tp_msk_map_tmp2((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2));
                       
        tp_img_map_tmp = padarray(tp_img_map,[offset1,offset2],'replicate','both');
        tp_img_map_tmp((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Img_Patch(1:templateSz(1),1:templateSz(2));
            
        tp_img_map_tmp2 = padarray(zeros(imgSz),[offset1,offset2],'replicate','both');
        tp_img_map_tmp2((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Img_Patch(1:templateSz(1),1:templateSz(2));
        %%%    
        tp_msk_map_ext = tp_msk_map_tmp.*double(tp_label_map_ext==0)+...
                tp_msk_map_ext.*double(tp_label_map_ext==1);
            
        tp_msk_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
        tp_msk_map3(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_tmp2(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
        tp_msk_map = tp_msk_map2;
        single_tp_map{2,m_seed} = sparse(logical(tp_msk_map3));
                        
        tp_img_map_ext = tp_img_map_tmp.*double(tp_label_map_ext==0)+...
                tp_img_map_ext.*double(tp_label_map_ext==1);
            
        tp_img_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_img_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
%         tp_img_map3(1:imgSz(1),1:imgSz(2)) = ...
%                 tp_img_map_tmp2(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
        tp_img_map = tp_img_map2;  
%         single_tp_map{1,m_seed} = tp_img_map3;
    end
    
    box_left_x = 1;
    box_left_y = 1;
    box_right_x = imgSz(2);
    box_right_y = imgSz(1);
    
    RawImg_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
    RawImg_Patch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = OrigImg(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
    All_Tp_Img_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
    All_Tp_Img_Patch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = tp_img_map(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
    %%% fill the space of 0 using the nearest neighbor rule
%     All_Tp_Img_Patch(All_Tp_Img_Patch==0) = NaN;
%     All_Tp_Img_Patch = NaNFix(All_Tp_Img_Patch);
    All_Tp_Img_Patch_Msk = double(All_Tp_Img_Patch~=0);
    All_Tp_Img_Patch_Msk = imfill(All_Tp_Img_Patch_Msk,'holes');
     
    single_tp_msk_cluster = cell(1,length(AreaPtRow));
    
    for m_seed = 1:length(AreaPtRow)
%         m_seed
%         Single_Tp_Msk_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
%         Single_Tp_Msk_Patch(1:(box_right_y-box_left_y+1),...
%             1:(box_right_x-box_left_x+1)) = single_tp_map{2,m_seed}(box_left_y:box_right_y,...
%                 box_left_x:box_right_x);
%  
%         single_tp_msk_cluster{1,m_seed} = sparse(Single_Tp_Msk_Patch);
        single_tp_msk_cluster{1,m_seed} = sparse(single_tp_map{2,m_seed});
    end
    
    SeedCount = SeedCount+1;
    
    Data_Cluster{1,SeedCount} = length(AreaPtRow); 
    Data_Cluster{2,SeedCount} = RawImg_Patch;
    Data_Cluster{3,SeedCount} = All_Tp_Img_Patch;
    Data_Cluster{4,SeedCount} = All_Tp_Img_Patch_Msk;
    Data_Cluster{6,SeedCount} = single_tp_msk_cluster;
    Data_Cluster{7,SeedCount} = ...
            [box_left_y,box_left_x,box_right_y,box_right_x];
end

SeedPtMapNew = SeedPtMap; 