function [SeedPtMapNew,Data_Cluster] = Detected_ImgPatch_Generator4(OrigImg,SeedPtMap,tp_cluster)
%%% this function is to create each cropped image patch with the masks
%%% written by Cheng Chen (chengchen@cmu.edu)

Data_Cluster = cell(4,1);
imgSz = size(OrigImg);
SeedCount = 0;
[SeedPtRow,SeedPtCol] = find(SeedPtMap);

AreaMap = zeros(imgSz(1),imgSz(2));

for i_pt = 1:length(SeedPtRow)
    i_pt
    XX = SeedPtCol(i_pt);
    YY = SeedPtRow (i_pt);
    
    Tp_Msk = uint8(tp_cluster{2,SeedPtMap(YY,XX)});
    
    MeanMskInfo = regionprops(Tp_Msk,'MinorAxisLength');
        
    templateSz = size(Tp_Msk);
    offset1 = double(templateSz(1)-1)/2;
    offset2 = double(templateSz(2)-1)/2;
      
    InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
    InitialMapExt(YY:YY+2*offset1,XX:XX+2*offset2) = ...
        Tp_Msk(1:templateSz(1),1:templateSz(2));
    
    
    InitialMap = zeros(imgSz(1),imgSz(2));
    InitialMap(1:imgSz(1),1:imgSz(2))= ...
        InitialMapExt(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
    
    H = round(MeanMskInfo.MinorAxisLength);
    W = round(H/3);
    
    InitialMapDilated = double(imdilate(InitialMap,ones(W,W))); % dilate the binary mask a little bit
    
    AreaMap = AreaMap+InitialMapDilated;
end

BinaryAreaMap = double(AreaMap);
[AllRegionsLabeled,RegionsNum] = bwlabel(BinaryAreaMap);

for j_area = 1:RegionsNum 
    fprintf('Start to extract the %dth patch to refine result.\n',j_area);
    SingleArea = double(AllRegionsLabeled==j_area);
    SeedsContained = SingleArea.*SeedPtMap;
    [AreaPtRow,AreaPtCol] = find(SeedsContained);
    
    if length(AreaPtRow)==1     % the case when only nucleus exists
        CurrentIdx = SeedPtMap(AreaPtRow(1),AreaPtCol(1));
        Tp_Msk = double(tp_cluster{2,CurrentIdx});
        Tp_Img = full(tp_cluster{1,CurrentIdx});
    
        templateSz = size(Tp_Msk);
    
        offset1 = double(templateSz(1)-1)/2;
        offset2 = double(templateSz(2)-1)/2;
        
        offset1p = round(2*offset1);
        offset2p = round(2*offset2);

        OrigImgExt = padarray(OrigImg,[offset1p,offset2p],'replicate','both');
        pSz(1) = 2*offset1p+1;
        pSz(2) = 2*offset2p+1;
        
        
        RawImg_Patch = zeros(pSz(1),pSz(2));
        RawImg_Patch(1:pSz(1),1:pSz(2)) = ...
            OrigImgExt((AreaPtRow(1)):(AreaPtRow(1)+2*offset1p),...
            (AreaPtCol(1)):(AreaPtCol(1)+2*offset2p));
        
        [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
        dX = dX-offset2-1;
        dY = dY-offset1-1;
        
        [dX2,dY2] = meshgrid(1:pSz(2),1:pSz(1));
        
        dX2 = dX2-offset2p-1;
        dY2 = dY2-offset1p-1;
        
        dX2 = dX2*1.1;
        dY2 = dY2*1.1;
        
        Tp_Img_Patch = interp2(dX,dY,Tp_Img,dX2,dY2);
        Tp_Img_Patch = NaNFix(Tp_Img_Patch);
        
        Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
        Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);

        SeedCount = SeedCount+1;
    
        Data_Cluster{1,SeedCount} = 1;
        Data_Cluster{2,SeedCount} = RawImg_Patch;
        Data_Cluster{3,SeedCount} = Tp_Img_Patch;
        Data_Cluster{4,SeedCount} = Tp_Msk_Patch;
        Data_Cluster{5,SeedCount} = [AreaPtRow(1),AreaPtCol(1)];
        
    elseif length(AreaPtRow)>1 % the case when two or more nuclei touch
        %%% first, we detect which region gets overlapped 
        
        flag = 0;
        
        shrink_vector = ones(length(AreaPtRow),1)*1.1;
        
        while flag==1
            [check_label] = Overlap_Detector(shrink_vector,tp_cluster,SeedPtMap,AreaPtRow,AreaPtCol);
        
            if max(check_label(:))==0
                flag = 0;
            end
        
            shrink_vector = shrink_vector+0.1*check_label;
        end
        
        single_tp_map = cell(2,length(AreaPtRow));
        
        tp_img_map = zeros(imgSz);
        tp_msk_map = zeros(imgSz); 
            
        for m_seed = 1:length(AreaPtRow)
                      m_seed
            CurrentIdx = SeedPtMap(AreaPtRow(m_seed),AreaPtCol(m_seed));
            Tp_Img = full(tp_cluster{1,CurrentIdx});
            Tp_Msk = double(tp_cluster{2,CurrentIdx});
            
            templateSz = size(Tp_Img);
    
            offset1 = double(templateSz(1)-1)/2;
            offset2 = double(templateSz(2)-1)/2;
            
            [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
            dX = dX-offset2-1;
            dY = dY-offset1-1;
        
            dX2 = dX*shrink_vector(m_seed);
            dY2 = dY*shrink_vector(m_seed);       
        
            Tp_Img_Patch = interp2(dX,dY,Tp_Img,dX2,dY2);
            Tp_Img_Patch = NaNFix(Tp_Img_Patch);
        
            Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
            Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);
                        
            tp_img_map_ext = padarray(tp_img_map,[offset1,offset2],'replicate','both');
            tp_msk_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
            tp_label_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
            
            %%% new coming template image and mask
            tp_msk_map_tmp = tp_msk_map_ext;
            tp_msk_map_tmp((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2)); 
            
            tp_msk_map_tmp2 = padarray(zeros(imgSz),[offset1,offset2],'replicate','both');
            tp_msk_map_tmp2((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2));
            
            
            tp_img_map_tmp = padarray(tp_img_map,[offset1,offset2],'replicate','both');
            tp_img_map_tmp((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Img_Patch(1:templateSz(1),1:templateSz(2));
            
            tp_img_map_tmp2 = padarray(zeros(imgSz),[offset1,offset2],'replicate','both');
            tp_img_map_tmp2((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Img_Patch(1:templateSz(1),1:templateSz(2));
            
            %
            tp_msk_map_ext = tp_msk_map_tmp.*double(tp_label_map_ext==0)+...
                tp_msk_map_ext.*double(tp_label_map_ext==1);
            
            tp_msk_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            tp_msk_map3(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_tmp2(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            tp_msk_map = tp_msk_map2;
            single_tp_map{2,m_seed} = sparse(logical(tp_msk_map3));
                        
            %
            tp_img_map_ext = tp_img_map_tmp.*double(tp_label_map_ext==0)+...
                tp_img_map_ext.*double(tp_label_map_ext==1);
            
            tp_img_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_img_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
%             tp_img_map3(1:imgSz(1),1:imgSz(2)) = ...
%                 tp_img_map_tmp2(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            tp_img_map = tp_img_map2;  
%             single_tp_map{1,m_seed} = tp_img_map3;
        end    
     
        STATS = regionprops(SingleArea,'BoundingBox');
        BoxInfo = STATS.BoundingBox;
            
        start_x = round(BoxInfo(1));
        start_y = round(BoxInfo(2));
        start_w = round(BoxInfo(3));
        start_h = round(BoxInfo(4));
            
        ww = round(start_w/8);
        hh = round(start_h/8);
            
        box_left_x = start_x-ww;
        box_left_y = start_y-hh;
            
        box_right_x = start_x+start_w+ww;
        box_right_y = start_y+start_h+hh;
        
        if box_left_x<=0
            box_left_x = 1;
        end
            
        if box_left_y<=0
            box_left_y = 1;
        end
            
        if box_right_x>=imgSz(2)
            box_right_x = imgSz(2)-1;
        end
            
        if box_right_y>=imgSz(1)
            box_right_y = imgSz(1)-1;
        end
            
        new_h = box_right_y-box_left_y+1;
        new_w = box_right_x-box_left_x+1;
            
        if mod(new_h,2)==0
            box_right_y = box_right_y+1;
        end
            
        if mod(new_w,2)==0
            box_right_x = box_right_x+1;
        end
        
        RawImg_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
        RawImg_Patch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = OrigImg(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
%         All_Tp_Msk_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
%         All_Tp_Msk_Patch(1:(box_right_y-box_left_y+1),...
%             1:(box_right_x-box_left_x+1)) = tp_msk_map(box_left_y:box_right_y,...
%             box_left_x:box_right_x);
        
        
        All_Tp_Img_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
        All_Tp_Img_Patch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = tp_img_map(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
%         All_Tp_Img_Patch(All_Tp_Img_Patch==0) = NaN;
%         All_Tp_Img_Patch = NaNFix(All_Tp_Img_Patch);
        
        All_Tp_Img_Patch_Msk = double(All_Tp_Img_Patch~=0);
        All_Tp_Img_Patch_Msk = imfill(All_Tp_Img_Patch_Msk,'holes');
        
        single_tp_img_cluster = cell(1,length(AreaPtRow));
        single_tp_msk_cluster = cell(1,length(AreaPtRow));
        
        
        for m_seed = 1:length(AreaPtRow)
            m_seed
            Single_Tp_Msk_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
            Single_Tp_Msk_Patch(1:(box_right_y-box_left_y+1),...
                1:(box_right_x-box_left_x+1)) = single_tp_map{2,m_seed}(box_left_y:box_right_y,...
                box_left_x:box_right_x);
        
        
%             Single_Tp_Img_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
%             Single_Tp_Img_Patch(1:(box_right_y-box_left_y+1),...
%                 1:(box_right_x-box_left_x+1)) = single_tp_map{1,m_seed}(box_left_y:box_right_y,...
%                 box_left_x:box_right_x);
        
%             Single_Tp_Img_Patch(Single_Tp_Img_Patch==0) = NaN;
%             Single_Tp_Img_Patch = NaNFix(Single_Tp_Img_Patch);
            
%             single_tp_img_cluster{1,m_seed} = Single_Tp_Img_Patch;
            single_tp_msk_cluster{1,m_seed} = logical(Single_Tp_Msk_Patch);
            
%             figure; imshow(Single_Tp_Img_Patch,[]);
%             figure; imshow(Single_Tp_Msk_Patch,[]);
        end
        
        
        SeedCount = SeedCount+1;
    
        Data_Cluster{1,SeedCount} = length(AreaPtRow); 
        Data_Cluster{2,SeedCount} = RawImg_Patch;
        Data_Cluster{3,SeedCount} = All_Tp_Img_Patch;
        Data_Cluster{4,SeedCount} = All_Tp_Img_Patch_Msk;
%         Data_Cluster{4,SeedCount} = All_Tp_Msk_Patch;
%         Data_Cluster{5,SeedCount} = single_tp_img_cluster;
        Data_Cluster{6,SeedCount} = single_tp_msk_cluster;
        Data_Cluster{7,SeedCount} = ...
            [box_left_y,box_left_x,box_right_y,box_right_x];
        
    end
end

SeedPtMapNew = SeedPtMap; 