function [SeedPtMapNew,Data_Cluster] = Detected_ImgPatch_Generator(OrigImg,SeedPtMap,tp_cluster)
%%% this function is to create each cropped image patch with the masks
%%% written by Cheng Chen (chengchen@cmu.edu)

Data_Cluster = cell(4,1);
imgSz = size(OrigImg);
SeedCount = 0;
[SeedPtRow,SeedPtCol] = find(SeedPtMap);

AreaMap = zeros(imgSz(1),imgSz(2));

for i_pt = 1:length(SeedPtRow)
    XX = SeedPtCol(i_pt);
    YY = SeedPtRow (i_pt);
    
    Tp_Msk = double(tp_cluster{2,SeedPtMap(YY,XX)});
    
    BinaryTemplateDilated = double(imdilate(Tp_Msk,ones(5,5)));
    
    templateSz = size(BinaryTemplateDilated);
    offset1 = double(templateSz(1)-1)/2;
    offset2 = double(templateSz(2)-1)/2;
      
    InitialMapExt = zeros(imgSz(1)+templateSz(1)-1,imgSz(2)+templateSz(2)-1);
    InitialMapExt(YY:YY+2*offset1,XX:XX+2*offset2) = ...
        BinaryTemplateDilated(1:templateSz(1),1:templateSz(2));
    InitialMap = zeros(imgSz(1),imgSz(2));
    InitialMap(1:imgSz(1),1:imgSz(2))= ...
        InitialMapExt(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
    AreaMap = AreaMap+InitialMap;
end

BinaryAreaMap = double(AreaMap);
[AllRegionsLabeled,Num] = bwlabel(BinaryAreaMap);

for j_area = 1:Num % the case when only nucleus exists
    SingleArea = double(AllRegionsLabeled==j_area);
    SeedsContained = SingleArea.*SeedPtMap;
    [AreaPtRow,AreaPtCol] = find(SeedsContained);
    
    if length(AreaPtRow)==1     
        CurrentIdx = SeedPtMap(AreaPtRow(1),AreaPtCol(1));
        Tp_Msk = double(tp_cluster{2,CurrentIdx});
        Tp_Img = full(tp_cluster{1,CurrentIdx});
        Tp_Msk = imerode(Tp_Msk,ones(5,5));
    
        templateSz = size(Tp_Msk);
    
        offset1 = double(templateSz(1)-1)/2;
        offset2 = double(templateSz(2)-1)/2;

        OrigImgExt = padarray(OrigImg,[offset1,offset2],'replicate','both');
        
        RawImg_Patch = zeros(templateSz(1),templateSz(2));
        RawImg_Patch(1:templateSz(1),1:templateSz(2)) = ...
            OrigImgExt((AreaPtRow(1)):(AreaPtRow(1)+2*offset1),...
            (AreaPtCol(1)):(AreaPtCol(1)+2*offset2));
        
        [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
        dX = dX-offset2-1;
        dY = dY-offset1-1;
        
        dX2 = dX*1.1;
        dY2 = dY*1.1;        
        
        Tp_Img_Patch = interp2(dX,dY,Tp_Img,dX2,dY2);
        Tp_Img_Patch = NaNFix(Tp_Img_Patch);
        
        Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
        Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);
        
%         figure; imshow(Tp_Img_Patch,[]); 
%         figure; imshow(Tp_Msk_Patch,[]);
        
%         SeedCount = SeedCount+1;
%     
%         Data_Cluster{1,SeedCount} = RawImg_Patch;
%         Data_Cluster{2,SeedCount} = Tp_Img_Patch;
%         Data_Cluster{3,SeedCount} = Tp_Msk_Patch;
%         Data_Cluster{4,SeedCount} = [AreaPtRow(1),AreaPtCol(1)];
%         Data_Cluster{5,SeedCount} = 1;
        
        
    
    elseif length(AreaPtRow)>1 % the case when two or more nuclei touch
        
        SeedsDistMap = bwdist(double(SeedsContained>0));
        SeedsDistMap2 = imimposemin(SeedsDistMap,double(SeedsContained));
        SplitArea = SingleArea.*watershed(SeedsDistMap2);
        
        
        
        Tp_Cluster_Update = cell(2,length(AreaPtRow));
        
        for m_seed = 1:length(AreaPtRow)
            CurrentIdx = SeedPtMap(AreaPtRow(m_seed),AreaPtCol(m_seed));
            Tp_Cluster_Update{1,m_seed} = full(tp_cluster{1,CurrentIdx});
            Tp_Cluster_Update{2,m_seed} = double(tp_cluster{2,CurrentIdx});
        end
        
        FLAG = 0;
        
        while FLAG==0
        disp('shrinking...');
        
        tp_img_map = zeros(imgSz);
        tp_msk_map = zeros(imgSz);
            
        for m_seed = 1:length(AreaPtRow)
                      
            Tp_Img = Tp_Cluster_Update{1,m_seed};
            Tp_Msk = Tp_Cluster_Update{2,m_seed};
            
            templateSz = size(Tp_Img);
    
            offset1 = double(templateSz(1)-1)/2;
            offset2 = double(templateSz(2)-1)/2;
            
            [dX,dY] = meshgrid(1:templateSz(2),1:templateSz(1));
        
            dX = dX-offset2-1;
            dY = dY-offset1-1;
        
            dX2 = dX*1.2;
            dY2 = dY*1.2;        
        
            Tp_Img_Patch = interp2(dX,dY,Tp_Img,dX2,dY2);
            Tp_Img_Patch = NaNFix(Tp_Img_Patch);
        
            Tp_Msk_Patch = interp2(dX,dY,Tp_Msk,dX2,dY2,'nearest');
            Tp_Msk_Patch = NaNFix(Tp_Msk_Patch);
            
            Tp_Cluster_Update{1,m_seed} = Tp_Img_Patch;
            Tp_Cluster_Update{2,m_seed} = Tp_Msk_Patch;
                  
            tp_img_map_ext = padarray(tp_img_map,[offset1,offset2],'replicate','both');
            tp_img_map_tmp = padarray(tp_img_map,[offset1,offset2],'replicate','both');
            tp_msk_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
            tp_label_map_ext = padarray(tp_msk_map,[offset1,offset2],'replicate','both');
            
            tp_msk_map_tmp = tp_msk_map_ext;
            
            tp_msk_map_tmp((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Msk_Patch(1:templateSz(1),1:templateSz(2)); 
            
            tp_msk_map_ext = tp_msk_map_tmp.*double(tp_label_map_ext==0)+...
                tp_msk_map_ext.*double(tp_label_map_ext==1);
            
            tp_msk_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_msk_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            tp_msk_map = tp_msk_map2;
            
            
            tp_img_map_tmp((AreaPtRow(m_seed)):(AreaPtRow(m_seed)+2*offset1),...
                (AreaPtCol(m_seed)):(AreaPtCol(m_seed)+2*offset2)) = ...
                Tp_Img_Patch(1:templateSz(1),1:templateSz(2));
            
            tp_img_map_ext = tp_img_map_tmp.*double(tp_label_map_ext==0)+...
                tp_img_map_ext.*double(tp_label_map_ext==1);
            
            tp_img_map2(1:imgSz(1),1:imgSz(2)) = ...
                tp_img_map_ext(offset1+1:offset1+imgSz(1),offset2+1:offset2+imgSz(2));
            tp_img_map = tp_img_map2;          
        end
        
        STATS = regionprops(SingleArea,'BoundingBox');
        BoxInfo = STATS.BoundingBox;
            
        start_x = round(BoxInfo(1));
        start_y = round(BoxInfo(2));
        start_w = round(BoxInfo(3));
        start_h = round(BoxInfo(4));
            
        ww = round(start_w/4);
        hh = round(start_h/4);
            
        box_left_x = start_x-ww;
        box_left_y = start_y-hh;
            
        box_right_x = start_x+start_w+ww;
        box_right_y = start_y+start_h+hh;
        
        if box_left_x<=0
            box_left_x = 1;
        end
            
        if box_left_y<=0
            box_left_y = 1;
        end
            
        if box_right_x>=imgSz(2)
            box_right_x = imgSz(2)-1;
        end
            
        if box_right_y>=imgSz(1)
            box_right_y = imgSz(1)-1;
        end
            
        new_h = box_right_y-box_left_y+1;
        new_w = box_right_x-box_left_x+1;
            
        if mod(new_h,2)==0
            box_right_y = box_right_y+1;
        end
            
        if mod(new_w,2)==0
            box_right_x = box_right_x+1;
        end
        
        RawImg_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
        RawImg_Patch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = OrigImg(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
        Tp_Msk_Patch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
        Tp_Msk_Patch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = tp_msk_map(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
        
        TpPatch = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
        TpPatch(1:(box_right_y-box_left_y+1),...
            1:(box_right_x-box_left_x+1)) = tp_img_map(box_left_y:box_right_y,...
            box_left_x:box_right_x);
        
        TpPatch(TpPatch==0) = NaN;
        Tp_Img_Patch = NaNFix(TpPatch);
        
        [L,N] = bwlabel(Tp_Msk_Patch);
        
        if N==length(AreaPtRow)
            FLAG = 1;
        end
        end
        
        SeedCount = SeedCount+1;
    
        Data_Cluster{1,SeedCount} = RawImg_Patch;
        Data_Cluster{2,SeedCount} = Tp_Img_Patch;
        Data_Cluster{3,SeedCount} = Tp_Msk_Patch;
        Data_Cluster{4,SeedCount} = ...
            [box_left_y,box_left_x,box_right_y,box_right_x];
        Data_Cluster{5,SeedCount} = max(SplitArea(:)); 
        
        figure; imshow(RawImg_Patch,[]);
        figure; imshow(Tp_Img_Patch,[]); impixelinfo;
        figure; imshow(Tp_Msk_Patch,[]); impixelinfo;
        pause;
        
    end
end

SeedPtMapNew = SeedPtMap; 