function [MeanTpMsk,MeanPatchMsk] = CreateMeanTpMsk(MeanTp)
[MeanTpMsk] = ManualSeg_LevelSet(MeanTp);
[M,N,K] = size(MeanTp);

STATS = regionprops(MeanTpMsk,'BoundingBox');
BoxInfo = STATS.BoundingBox;
            
start_x = round(BoxInfo(1));
start_y = round(BoxInfo(2));
start_w = round(BoxInfo(3));
start_h = round(BoxInfo(4));
            
ww = round(start_w/5);
hh = round(start_h/5);
            
box_left_x = start_x-ww;
box_left_y = start_y-hh;
            
box_right_x = start_x+start_w+ww;
box_right_y = start_y+start_h+hh;

if box_left_x<=0
    box_left_x = 1;
end
            
if box_left_y<=0
    box_left_y = 1;
end
            
if box_right_x>=N
    box_right_x = N-1;
end
            
if box_right_y>=M
    box_right_y = M-1;
end

MeanPatchMsk = zeros(M,N,K);

MeanPatchMsk(box_left_y:box_right_y,box_left_x:box_right_x,1:K) = 1;