function [Tp_New,Msk_New] = AdaptiveTp(Tp,Msk)
%%% we create the template with adapative size based on binary mask
%%% written by Cheng Chen (chengchen@cmu.edu)
[M,N,K] = size(Tp);

STATS = regionprops(Msk,'BoundingBox');
BoxInfo = STATS.BoundingBox;
            
start_x = round(BoxInfo(1));
start_y = round(BoxInfo(2));
start_w = round(BoxInfo(3));
start_h = round(BoxInfo(4));
            
ww = round(start_w/35)+5;
hh = round(start_h/35)+5;
            
box_left_x = start_x-ww;
box_left_y = start_y-hh;
            
box_right_x = start_x+start_w+ww;
box_right_y = start_y+start_h+hh;
            
if box_left_x<=0
    box_left_x = 1;
end
            
if box_left_y<=0
    box_left_y = 1;
end
            
if box_right_x>=size(Msk,2)
    box_right_x = size(Msk,2)-1;
end
            
if box_right_y>=size(Msk,1)
    box_right_y = size(Msk,1)-1;
end
            
new_h = box_right_y-box_left_y+1;
new_w = box_right_x-box_left_x+1;

if mod(new_h,2)==0
    box_right_y = box_right_y+1;
end

if mod(new_w,2)==0
    box_right_x = box_right_x+1;
end
            
Tp_New = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1,K);
Tp_New(1:(box_right_y-box_left_y+1),...
    1:(box_right_x-box_left_x+1),1:K) = Tp(box_left_y:box_right_y,...
    box_left_x:box_right_x,1:K);

Msk_New = zeros(box_right_y-box_left_y+1,box_right_x-box_left_x+1);
Msk_New(1:(box_right_y-box_left_y+1),...
    1:(box_right_x-box_left_x+1)) = Msk(box_left_y:box_right_y,...
    box_left_x:box_right_x);
            
